/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentVersionsResponse;

public class ListAgentVersionsIterable
implements SdkIterable<ListAgentVersionsResponse> {
    private final BedrockAgentClient client;
    private final ListAgentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentVersionsIterable(BedrockAgentClient client, ListAgentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentVersionsResponseFetcher();
    }

    public Iterator<ListAgentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentVersionSummary> agentVersionSummaries() {
        Function<ListAgentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentVersionSummaries() != null) {
                return response.agentVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentVersionsResponseFetcher
    implements SyncPageFetcher<ListAgentVersionsResponse> {
        private ListAgentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentVersionsResponse nextPage(ListAgentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentVersionsIterable.this.client.listAgentVersions(ListAgentVersionsIterable.this.firstRequest);
            }
            return ListAgentVersionsIterable.this.client.listAgentVersions((ListAgentVersionsRequest)((Object)ListAgentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

