/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FilterListCopier;
import software.amazon.awssdk.services.bedrockagent.model.WebCrawlerLimits;
import software.amazon.awssdk.services.bedrockagent.model.WebScopeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebCrawlerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebCrawlerConfiguration> {
    private static final SdkField<WebCrawlerLimits> CRAWLER_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerLimits").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::crawlerLimits)).setter(WebCrawlerConfiguration.setter(Builder::crawlerLimits)).constructor(WebCrawlerLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerLimits").build()}).build();
    private static final SdkField<List<String>> EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exclusionFilters").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::exclusionFilters)).setter(WebCrawlerConfiguration.setter(Builder::exclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inclusionFilters").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::inclusionFilters)).setter(WebCrawlerConfiguration.setter(Builder::inclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(WebCrawlerConfiguration.getter(WebCrawlerConfiguration::scopeAsString)).setter(WebCrawlerConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_LIMITS_FIELD, EXCLUSION_FILTERS_FIELD, INCLUSION_FILTERS_FIELD, SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("crawlerLimits", CRAWLER_LIMITS_FIELD);
            this.put("exclusionFilters", EXCLUSION_FILTERS_FIELD);
            this.put("inclusionFilters", INCLUSION_FILTERS_FIELD);
            this.put("scope", SCOPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final WebCrawlerLimits crawlerLimits;
    private final List<String> exclusionFilters;
    private final List<String> inclusionFilters;
    private final String scope;

    private WebCrawlerConfiguration(BuilderImpl builder) {
        this.crawlerLimits = builder.crawlerLimits;
        this.exclusionFilters = builder.exclusionFilters;
        this.inclusionFilters = builder.inclusionFilters;
        this.scope = builder.scope;
    }

    public final WebCrawlerLimits crawlerLimits() {
        return this.crawlerLimits;
    }

    public final boolean hasExclusionFilters() {
        return this.exclusionFilters != null && !(this.exclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionFilters() {
        return this.exclusionFilters;
    }

    public final boolean hasInclusionFilters() {
        return this.inclusionFilters != null && !(this.inclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionFilters() {
        return this.inclusionFilters;
    }

    public final WebScopeType scope() {
        return WebScopeType.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFilters() ? this.exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFilters() ? this.inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerConfiguration)) {
            return false;
        }
        WebCrawlerConfiguration other = (WebCrawlerConfiguration)obj;
        return Objects.equals(this.crawlerLimits(), other.crawlerLimits()) && this.hasExclusionFilters() == other.hasExclusionFilters() && Objects.equals(this.exclusionFilters(), other.exclusionFilters()) && this.hasInclusionFilters() == other.hasInclusionFilters() && Objects.equals(this.inclusionFilters(), other.inclusionFilters()) && Objects.equals(this.scopeAsString(), other.scopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WebCrawlerConfiguration").add("CrawlerLimits", (Object)this.crawlerLimits()).add("ExclusionFilters", (Object)(this.exclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")).add("InclusionFilters", (Object)(this.inclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", (Object)this.scopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crawlerLimits": {
                return Optional.ofNullable(clazz.cast(this.crawlerLimits()));
            }
            case "exclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.exclusionFilters()));
            }
            case "inclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.inclusionFilters()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WebCrawlerConfiguration, T> g) {
        return obj -> g.apply((WebCrawlerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WebCrawlerLimits crawlerLimits;
        private List<String> exclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(WebCrawlerConfiguration model) {
            this.crawlerLimits(model.crawlerLimits);
            this.exclusionFilters(model.exclusionFilters);
            this.inclusionFilters(model.inclusionFilters);
            this.scope(model.scope);
        }

        public final WebCrawlerLimits.Builder getCrawlerLimits() {
            return this.crawlerLimits != null ? this.crawlerLimits.toBuilder() : null;
        }

        public final void setCrawlerLimits(WebCrawlerLimits.BuilderImpl crawlerLimits) {
            this.crawlerLimits = crawlerLimits != null ? crawlerLimits.build() : null;
        }

        @Override
        public final Builder crawlerLimits(WebCrawlerLimits crawlerLimits) {
            this.crawlerLimits = crawlerLimits;
            return this;
        }

        public final Collection<String> getExclusionFilters() {
            if (this.exclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionFilters;
        }

        public final void setExclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(String ... exclusionFilters) {
            this.exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        public final Collection<String> getInclusionFilters() {
            if (this.inclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionFilters;
        }

        public final void setInclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(String ... inclusionFilters) {
            this.inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(WebScopeType scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public WebCrawlerConfiguration build() {
            return new WebCrawlerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebCrawlerConfiguration> {
        public Builder crawlerLimits(WebCrawlerLimits var1);

        default public Builder crawlerLimits(Consumer<WebCrawlerLimits.Builder> crawlerLimits) {
            return this.crawlerLimits((WebCrawlerLimits)((WebCrawlerLimits.Builder)WebCrawlerLimits.builder().applyMutation(crawlerLimits)).build());
        }

        public Builder exclusionFilters(Collection<String> var1);

        public Builder exclusionFilters(String ... var1);

        public Builder inclusionFilters(Collection<String> var1);

        public Builder inclusionFilters(String ... var1);

        public Builder scope(String var1);

        public Builder scope(WebScopeType var1);
    }
}

