/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentAliasRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateAgentAliasRequest> {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(UpdateAgentAliasRequest.getter(UpdateAgentAliasRequest::agentAliasId)).setter(UpdateAgentAliasRequest.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasName").getter(UpdateAgentAliasRequest.getter(UpdateAgentAliasRequest::agentAliasName)).setter(UpdateAgentAliasRequest.setter(Builder::agentAliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasName").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(UpdateAgentAliasRequest.getter(UpdateAgentAliasRequest::agentId)).setter(UpdateAgentAliasRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAgentAliasRequest.getter(UpdateAgentAliasRequest::description)).setter(UpdateAgentAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<AgentAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(UpdateAgentAliasRequest.getter(UpdateAgentAliasRequest::routingConfiguration)).setter(UpdateAgentAliasRequest.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD, AGENT_ALIAS_NAME_FIELD, AGENT_ID_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
            this.put("agentAliasName", AGENT_ALIAS_NAME_FIELD);
            this.put("agentId", AGENT_ID_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        }
    });
    private final String agentAliasId;
    private final String agentAliasName;
    private final String agentId;
    private final String description;
    private final List<AgentAliasRoutingConfigurationListItem> routingConfiguration;

    private UpdateAgentAliasRequest(BuilderImpl builder) {
        super(builder);
        this.agentAliasId = builder.agentAliasId;
        this.agentAliasName = builder.agentAliasName;
        this.agentId = builder.agentId;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final String agentAliasName() {
        return this.agentAliasName;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<AgentAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentAliasRequest)) {
            return false;
        }
        UpdateAgentAliasRequest other = (UpdateAgentAliasRequest)((Object)obj);
        return Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.agentAliasName(), other.agentAliasName()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentAliasRequest").add("AgentAliasId", (Object)this.agentAliasId()).add("AgentAliasName", (Object)this.agentAliasName()).add("AgentId", (Object)this.agentId()).add("Description", (Object)this.description()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "agentAliasName": {
                return Optional.ofNullable(clazz.cast(this.agentAliasName()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentAliasRequest, T> g) {
        return obj -> g.apply((UpdateAgentAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String agentAliasId;
        private String agentAliasName;
        private String agentId;
        private String description;
        private List<AgentAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentAliasRequest model) {
            super(model);
            this.agentAliasId(model.agentAliasId);
            this.agentAliasName(model.agentAliasName);
            this.agentId(model.agentId);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentAliasName() {
            return this.agentAliasName;
        }

        public final void setAgentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
        }

        @Override
        public final Builder agentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AgentAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<AgentAliasRoutingConfigurationListItem.Builder> result = AgentAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<AgentAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(AgentAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (AgentAliasRoutingConfigurationListItem)((AgentAliasRoutingConfigurationListItem.Builder)AgentAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentAliasRequest build() {
            return new UpdateAgentAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentAliasRequest> {
        public Builder agentAliasId(String var1);

        public Builder agentAliasName(String var1);

        public Builder agentId(String var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(AgentAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

