/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.AnyToolChoice;
import software.amazon.awssdk.services.bedrockagent.model.AutoToolChoice;
import software.amazon.awssdk.services.bedrockagent.model.SpecificToolChoice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolChoice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolChoice> {
    private static final SdkField<AnyToolChoice> ANY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("any").getter(ToolChoice.getter(ToolChoice::any)).setter(ToolChoice.setter(Builder::any)).constructor(AnyToolChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("any").build()}).build();
    private static final SdkField<AutoToolChoice> AUTO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("auto").getter(ToolChoice.getter(ToolChoice::auto)).setter(ToolChoice.setter(Builder::auto)).constructor(AutoToolChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auto").build()}).build();
    private static final SdkField<SpecificToolChoice> TOOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tool").getter(ToolChoice.getter(ToolChoice::tool)).setter(ToolChoice.setter(Builder::tool)).constructor(SpecificToolChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANY_FIELD, AUTO_FIELD, TOOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("any", ANY_FIELD);
            this.put("auto", AUTO_FIELD);
            this.put("tool", TOOL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AnyToolChoice any;
    private final AutoToolChoice auto;
    private final SpecificToolChoice tool;
    private final Type type;

    private ToolChoice(BuilderImpl builder) {
        this.any = builder.any;
        this.auto = builder.auto;
        this.tool = builder.tool;
        this.type = builder.type;
    }

    public final AnyToolChoice any() {
        return this.any;
    }

    public final AutoToolChoice auto() {
        return this.auto;
    }

    public final SpecificToolChoice tool() {
        return this.tool;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.any());
        hashCode = 31 * hashCode + Objects.hashCode(this.auto());
        hashCode = 31 * hashCode + Objects.hashCode(this.tool());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolChoice)) {
            return false;
        }
        ToolChoice other = (ToolChoice)obj;
        return Objects.equals(this.any(), other.any()) && Objects.equals(this.auto(), other.auto()) && Objects.equals(this.tool(), other.tool());
    }

    public final String toString() {
        return ToString.builder((String)"ToolChoice").add("Any", (Object)this.any()).add("Auto", (Object)this.auto()).add("Tool", (Object)this.tool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "any": {
                return Optional.ofNullable(clazz.cast(this.any()));
            }
            case "auto": {
                return Optional.ofNullable(clazz.cast(this.auto()));
            }
            case "tool": {
                return Optional.ofNullable(clazz.cast(this.tool()));
            }
        }
        return Optional.empty();
    }

    public static ToolChoice fromAny(AnyToolChoice any) {
        return (ToolChoice)ToolChoice.builder().any(any).build();
    }

    public static ToolChoice fromAny(Consumer<AnyToolChoice.Builder> any) {
        AnyToolChoice.Builder builder = AnyToolChoice.builder();
        any.accept(builder);
        return ToolChoice.fromAny((AnyToolChoice)builder.build());
    }

    public static ToolChoice fromAuto(AutoToolChoice auto) {
        return (ToolChoice)ToolChoice.builder().auto(auto).build();
    }

    public static ToolChoice fromAuto(Consumer<AutoToolChoice.Builder> auto) {
        AutoToolChoice.Builder builder = AutoToolChoice.builder();
        auto.accept(builder);
        return ToolChoice.fromAuto((AutoToolChoice)builder.build());
    }

    public static ToolChoice fromTool(SpecificToolChoice tool) {
        return (ToolChoice)ToolChoice.builder().tool(tool).build();
    }

    public static ToolChoice fromTool(Consumer<SpecificToolChoice.Builder> tool) {
        SpecificToolChoice.Builder builder = SpecificToolChoice.builder();
        tool.accept(builder);
        return ToolChoice.fromTool((SpecificToolChoice)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ToolChoice, T> g) {
        return obj -> g.apply((ToolChoice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ANY,
        AUTO,
        TOOL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AnyToolChoice any;
        private AutoToolChoice auto;
        private SpecificToolChoice tool;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolChoice model) {
            this.any(model.any);
            this.auto(model.auto);
            this.tool(model.tool);
        }

        public final AnyToolChoice.Builder getAny() {
            return this.any != null ? this.any.toBuilder() : null;
        }

        public final void setAny(AnyToolChoice.BuilderImpl any) {
            AnyToolChoice oldValue = this.any;
            this.any = any != null ? any.build() : null;
            this.handleUnionValueChange(Type.ANY, oldValue, this.any);
        }

        @Override
        public final Builder any(AnyToolChoice any) {
            AnyToolChoice oldValue = this.any;
            this.any = any;
            this.handleUnionValueChange(Type.ANY, oldValue, this.any);
            return this;
        }

        public final AutoToolChoice.Builder getAuto() {
            return this.auto != null ? this.auto.toBuilder() : null;
        }

        public final void setAuto(AutoToolChoice.BuilderImpl auto) {
            AutoToolChoice oldValue = this.auto;
            this.auto = auto != null ? auto.build() : null;
            this.handleUnionValueChange(Type.AUTO, oldValue, this.auto);
        }

        @Override
        public final Builder auto(AutoToolChoice auto) {
            AutoToolChoice oldValue = this.auto;
            this.auto = auto;
            this.handleUnionValueChange(Type.AUTO, oldValue, this.auto);
            return this;
        }

        public final SpecificToolChoice.Builder getTool() {
            return this.tool != null ? this.tool.toBuilder() : null;
        }

        public final void setTool(SpecificToolChoice.BuilderImpl tool) {
            SpecificToolChoice oldValue = this.tool;
            this.tool = tool != null ? tool.build() : null;
            this.handleUnionValueChange(Type.TOOL, oldValue, this.tool);
        }

        @Override
        public final Builder tool(SpecificToolChoice tool) {
            SpecificToolChoice oldValue = this.tool;
            this.tool = tool;
            this.handleUnionValueChange(Type.TOOL, oldValue, this.tool);
            return this;
        }

        public ToolChoice build() {
            return new ToolChoice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolChoice> {
        public Builder any(AnyToolChoice var1);

        default public Builder any(Consumer<AnyToolChoice.Builder> any) {
            return this.any((AnyToolChoice)((AnyToolChoice.Builder)AnyToolChoice.builder().applyMutation(any)).build());
        }

        public Builder auto(AutoToolChoice var1);

        default public Builder auto(Consumer<AutoToolChoice.Builder> auto) {
            return this.auto((AutoToolChoice)((AutoToolChoice.Builder)AutoToolChoice.builder().applyMutation(auto)).build());
        }

        public Builder tool(SpecificToolChoice var1);

        default public Builder tool(Consumer<SpecificToolChoice.Builder> tool) {
            return this.tool((SpecificToolChoice)((SpecificToolChoice.Builder)SpecificToolChoice.builder().applyMutation(tool)).build());
        }
    }
}

