/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodeConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodeInput;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodeInputsCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodeOutput;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodeOutputsCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowNode> {
    private static final SdkField<FlowNodeConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(FlowNode.getter(FlowNode::configuration)).setter(FlowNode.setter(Builder::configuration)).constructor(FlowNodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<List<FlowNodeInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(FlowNode.getter(FlowNode::inputs)).setter(FlowNode.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowNodeInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FlowNode.getter(FlowNode::name)).setter(FlowNode.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<FlowNodeOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputs").getter(FlowNode.getter(FlowNode::outputs)).setter(FlowNode.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowNodeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FlowNode.getter(FlowNode::typeAsString)).setter(FlowNode.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, INPUTS_FIELD, NAME_FIELD, OUTPUTS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final FlowNodeConfiguration configuration;
    private final List<FlowNodeInput> inputs;
    private final String name;
    private final List<FlowNodeOutput> outputs;
    private final String type;

    private FlowNode(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.inputs = builder.inputs;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.type = builder.type;
    }

    public final FlowNodeConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<FlowNodeInput> inputs() {
        return this.inputs;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<FlowNodeOutput> outputs() {
        return this.outputs;
    }

    public final FlowNodeType type() {
        return FlowNodeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowNode)) {
            return false;
        }
        FlowNode other = (FlowNode)obj;
        return Objects.equals(this.configuration(), other.configuration()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.name(), other.name()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowNode").add("Configuration", (Object)this.configuration()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Name", (Object)this.name()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowNode, T> g) {
        return obj -> g.apply((FlowNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FlowNodeConfiguration configuration;
        private List<FlowNodeInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<FlowNodeOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowNode model) {
            this.configuration(model.configuration);
            this.inputs(model.inputs);
            this.name(model.name);
            this.outputs(model.outputs);
            this.type(model.type);
        }

        public final FlowNodeConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(FlowNodeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FlowNodeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<FlowNodeInput.Builder> getInputs() {
            List<FlowNodeInput.Builder> result = FlowNodeInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<FlowNodeInput.BuilderImpl> inputs) {
            this.inputs = FlowNodeInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<FlowNodeInput> inputs) {
            this.inputs = FlowNodeInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(FlowNodeInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<FlowNodeInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (FlowNodeInput)((FlowNodeInput.Builder)FlowNodeInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FlowNodeOutput.Builder> getOutputs() {
            List<FlowNodeOutput.Builder> result = FlowNodeOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<FlowNodeOutput.BuilderImpl> outputs) {
            this.outputs = FlowNodeOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<FlowNodeOutput> outputs) {
            this.outputs = FlowNodeOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(FlowNodeOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<FlowNodeOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (FlowNodeOutput)((FlowNodeOutput.Builder)FlowNodeOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FlowNode build() {
            return new FlowNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowNode> {
        public Builder configuration(FlowNodeConfiguration var1);

        default public Builder configuration(Consumer<FlowNodeConfiguration.Builder> configuration) {
            return this.configuration((FlowNodeConfiguration)((FlowNodeConfiguration.Builder)FlowNodeConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder inputs(Collection<FlowNodeInput> var1);

        public Builder inputs(FlowNodeInput ... var1);

        public Builder inputs(Consumer<FlowNodeInput.Builder> ... var1);

        public Builder name(String var1);

        public Builder outputs(Collection<FlowNodeOutput> var1);

        public Builder outputs(FlowNodeOutput ... var1);

        public Builder outputs(Consumer<FlowNodeOutput.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(FlowNodeType var1);
    }
}

