/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebScopeType {
    HOST_ONLY("HOST_ONLY"),
    SUBDOMAINS("SUBDOMAINS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebScopeType> VALUE_MAP;
    private final String value;

    private WebScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebScopeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebScopeType> knownValues() {
        EnumSet<WebScopeType> knownValues = EnumSet.allOf(WebScopeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebScopeType.class, WebScopeType::toString);
    }
}

