/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowAliasesResponse;

public class ListFlowAliasesIterable
implements SdkIterable<ListFlowAliasesResponse> {
    private final BedrockAgentClient client;
    private final ListFlowAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowAliasesIterable(BedrockAgentClient client, ListFlowAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowAliasesResponseFetcher();
    }

    public Iterator<ListFlowAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowAliasSummary> flowAliasSummaries() {
        Function<ListFlowAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowAliasSummaries() != null) {
                return response.flowAliasSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowAliasesResponseFetcher
    implements SyncPageFetcher<ListFlowAliasesResponse> {
        private ListFlowAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowAliasesResponse nextPage(ListFlowAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListFlowAliasesIterable.this.client.listFlowAliases(ListFlowAliasesIterable.this.firstRequest);
            }
            return ListFlowAliasesIterable.this.client.listFlowAliases((ListFlowAliasesRequest)((Object)ListFlowAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

