/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.MemoryConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateAgentRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(UpdateAgentRequest.getter(UpdateAgentRequest::agentId)).setter(UpdateAgentRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentName").getter(UpdateAgentRequest.getter(UpdateAgentRequest::agentName)).setter(UpdateAgentRequest.setter(Builder::agentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()}).build();
    private static final SdkField<String> AGENT_RESOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentResourceRoleArn").getter(UpdateAgentRequest.getter(UpdateAgentRequest::agentResourceRoleArn)).setter(UpdateAgentRequest.setter(Builder::agentResourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentResourceRoleArn").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(UpdateAgentRequest.getter(UpdateAgentRequest::customerEncryptionKeyArn)).setter(UpdateAgentRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAgentRequest.getter(UpdateAgentRequest::description)).setter(UpdateAgentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModel").getter(UpdateAgentRequest.getter(UpdateAgentRequest::foundationModel)).setter(UpdateAgentRequest.setter(Builder::foundationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(UpdateAgentRequest.getter(UpdateAgentRequest::guardrailConfiguration)).setter(UpdateAgentRequest.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(UpdateAgentRequest.getter(UpdateAgentRequest::idleSessionTTLInSeconds)).setter(UpdateAgentRequest.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instruction").getter(UpdateAgentRequest.getter(UpdateAgentRequest::instruction)).setter(UpdateAgentRequest.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<MemoryConfiguration> MEMORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryConfiguration").getter(UpdateAgentRequest.getter(UpdateAgentRequest::memoryConfiguration)).setter(UpdateAgentRequest.setter(Builder::memoryConfiguration)).constructor(MemoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryConfiguration").build()}).build();
    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptOverrideConfiguration").getter(UpdateAgentRequest.getter(UpdateAgentRequest::promptOverrideConfiguration)).setter(UpdateAgentRequest.setter(Builder::promptOverrideConfiguration)).constructor(PromptOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_NAME_FIELD, AGENT_RESOURCE_ROLE_ARN_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DESCRIPTION_FIELD, FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, INSTRUCTION_FIELD, MEMORY_CONFIGURATION_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD));
    private final String agentId;
    private final String agentName;
    private final String agentResourceRoleArn;
    private final String customerEncryptionKeyArn;
    private final String description;
    private final String foundationModel;
    private final GuardrailConfiguration guardrailConfiguration;
    private final Integer idleSessionTTLInSeconds;
    private final String instruction;
    private final MemoryConfiguration memoryConfiguration;
    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private UpdateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentName = builder.agentName;
        this.agentResourceRoleArn = builder.agentResourceRoleArn;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.description = builder.description;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.instruction = builder.instruction;
        this.memoryConfiguration = builder.memoryConfiguration;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentName() {
        return this.agentName;
    }

    public final String agentResourceRoleArn() {
        return this.agentResourceRoleArn;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String description() {
        return this.description;
    }

    public final String foundationModel() {
        return this.foundationModel;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final MemoryConfiguration memoryConfiguration() {
        return this.memoryConfiguration;
    }

    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return this.promptOverrideConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentResourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptOverrideConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRequest)) {
            return false;
        }
        UpdateAgentRequest other = (UpdateAgentRequest)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentName(), other.agentName()) && Objects.equals(this.agentResourceRoleArn(), other.agentResourceRoleArn()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.foundationModel(), other.foundationModel()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.instruction(), other.instruction()) && Objects.equals(this.memoryConfiguration(), other.memoryConfiguration()) && Objects.equals(this.promptOverrideConfiguration(), other.promptOverrideConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentRequest").add("AgentId", (Object)this.agentId()).add("AgentName", (Object)this.agentName()).add("AgentResourceRoleArn", (Object)this.agentResourceRoleArn()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("Description", (Object)this.description()).add("FoundationModel", (Object)this.foundationModel()).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("MemoryConfiguration", (Object)this.memoryConfiguration()).add("PromptOverrideConfiguration", (Object)(this.promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentName": {
                return Optional.ofNullable(clazz.cast(this.agentName()));
            }
            case "agentResourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.agentResourceRoleArn()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "foundationModel": {
                return Optional.ofNullable(clazz.cast(this.foundationModel()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "memoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.memoryConfiguration()));
            }
            case "promptOverrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.promptOverrideConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRequest, T> g) {
        return obj -> g.apply((UpdateAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String agentId;
        private String agentName;
        private String agentResourceRoleArn;
        private String customerEncryptionKeyArn;
        private String description;
        private String foundationModel;
        private GuardrailConfiguration guardrailConfiguration;
        private Integer idleSessionTTLInSeconds;
        private String instruction;
        private MemoryConfiguration memoryConfiguration;
        private PromptOverrideConfiguration promptOverrideConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRequest model) {
            super(model);
            this.agentId(model.agentId);
            this.agentName(model.agentName);
            this.agentResourceRoleArn(model.agentResourceRoleArn);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.description(model.description);
            this.foundationModel(model.foundationModel);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.instruction(model.instruction);
            this.memoryConfiguration(model.memoryConfiguration);
            this.promptOverrideConfiguration(model.promptOverrideConfiguration);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentName() {
            return this.agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getAgentResourceRoleArn() {
            return this.agentResourceRoleArn;
        }

        public final void setAgentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
        }

        @Override
        public final Builder agentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFoundationModel() {
            return this.foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final MemoryConfiguration.Builder getMemoryConfiguration() {
            return this.memoryConfiguration != null ? this.memoryConfiguration.toBuilder() : null;
        }

        public final void setMemoryConfiguration(MemoryConfiguration.BuilderImpl memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration != null ? memoryConfiguration.build() : null;
        }

        @Override
        public final Builder memoryConfiguration(MemoryConfiguration memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration;
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return this.promptOverrideConfiguration != null ? this.promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentRequest build() {
            return new UpdateAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentRequest> {
        public Builder agentId(String var1);

        public Builder agentName(String var1);

        public Builder agentResourceRoleArn(String var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder description(String var1);

        public Builder foundationModel(String var1);

        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder instruction(String var1);

        public Builder memoryConfiguration(MemoryConfiguration var1);

        default public Builder memoryConfiguration(Consumer<MemoryConfiguration.Builder> memoryConfiguration) {
            return this.memoryConfiguration((MemoryConfiguration)((MemoryConfiguration.Builder)MemoryConfiguration.builder().applyMutation(memoryConfiguration)).build());
        }

        public Builder promptOverrideConfiguration(PromptOverrideConfiguration var1);

        default public Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return this.promptOverrideConfiguration((PromptOverrideConfiguration)((PromptOverrideConfiguration.Builder)PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

