/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagent.model.GuardrailConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentSummary> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AgentSummary.getter(AgentSummary::agentId)).setter(AgentSummary.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentName").getter(AgentSummary.getter(AgentSummary::agentName)).setter(AgentSummary.setter(Builder::agentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()}).build();
    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentStatus").getter(AgentSummary.getter(AgentSummary::agentStatusAsString)).setter(AgentSummary.setter(Builder::agentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentSummary.getter(AgentSummary::description)).setter(AgentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(AgentSummary.getter(AgentSummary::guardrailConfiguration)).setter(AgentSummary.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<String> LATEST_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestAgentVersion").getter(AgentSummary.getter(AgentSummary::latestAgentVersion)).setter(AgentSummary.setter(Builder::latestAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAgentVersion").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AgentSummary.getter(AgentSummary::updatedAt)).setter(AgentSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_NAME_FIELD, AGENT_STATUS_FIELD, DESCRIPTION_FIELD, GUARDRAIL_CONFIGURATION_FIELD, LATEST_AGENT_VERSION_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentId;
    private final String agentName;
    private final String agentStatus;
    private final String description;
    private final GuardrailConfiguration guardrailConfiguration;
    private final String latestAgentVersion;
    private final Instant updatedAt;

    private AgentSummary(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentName = builder.agentName;
        this.agentStatus = builder.agentStatus;
        this.description = builder.description;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.latestAgentVersion = builder.latestAgentVersion;
        this.updatedAt = builder.updatedAt;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentName() {
        return this.agentName;
    }

    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(this.agentStatus);
    }

    public final String agentStatusAsString() {
        return this.agentStatus;
    }

    public final String description() {
        return this.description;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final String latestAgentVersion() {
        return this.latestAgentVersion;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentSummary)) {
            return false;
        }
        AgentSummary other = (AgentSummary)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentName(), other.agentName()) && Objects.equals(this.agentStatusAsString(), other.agentStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.latestAgentVersion(), other.latestAgentVersion()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AgentSummary").add("AgentId", (Object)this.agentId()).add("AgentName", (Object)this.agentName()).add("AgentStatus", (Object)this.agentStatusAsString()).add("Description", (Object)this.description()).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("LatestAgentVersion", (Object)this.latestAgentVersion()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentName": {
                return Optional.ofNullable(clazz.cast(this.agentName()));
            }
            case "agentStatus": {
                return Optional.ofNullable(clazz.cast(this.agentStatusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "latestAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.latestAgentVersion()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentSummary, T> g) {
        return obj -> g.apply((AgentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private String agentName;
        private String agentStatus;
        private String description;
        private GuardrailConfiguration guardrailConfiguration;
        private String latestAgentVersion;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentSummary model) {
            this.agentId(model.agentId);
            this.agentName(model.agentName);
            this.agentStatus(model.agentStatus);
            this.description(model.description);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.latestAgentVersion(model.latestAgentVersion);
            this.updatedAt(model.updatedAt);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentName() {
            return this.agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getAgentStatus() {
            return this.agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final String getLatestAgentVersion() {
            return this.latestAgentVersion;
        }

        public final void setLatestAgentVersion(String latestAgentVersion) {
            this.latestAgentVersion = latestAgentVersion;
        }

        @Override
        public final Builder latestAgentVersion(String latestAgentVersion) {
            this.latestAgentVersion = latestAgentVersion;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public AgentSummary build() {
            return new AgentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentSummary> {
        public Builder agentId(String var1);

        public Builder agentName(String var1);

        public Builder agentStatus(String var1);

        public Builder agentStatus(AgentStatus var1);

        public Builder description(String var1);

        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder latestAgentVersion(String var1);

        public Builder updatedAt(Instant var1);
    }
}

