/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.S3PrefixesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataSourceConfiguration> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketArn").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::bucketArn)).setter(S3DataSourceConfiguration.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inclusionPrefixes").getter(S3DataSourceConfiguration.getter(S3DataSourceConfiguration::inclusionPrefixes)).setter(S3DataSourceConfiguration.setter(Builder::inclusionPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, INCLUSION_PREFIXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketArn;
    private final List<String> inclusionPrefixes;

    private S3DataSourceConfiguration(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.inclusionPrefixes = builder.inclusionPrefixes;
    }

    public final String bucketArn() {
        return this.bucketArn;
    }

    public final boolean hasInclusionPrefixes() {
        return this.inclusionPrefixes != null && !(this.inclusionPrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPrefixes() {
        return this.inclusionPrefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPrefixes() ? this.inclusionPrefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSourceConfiguration)) {
            return false;
        }
        S3DataSourceConfiguration other = (S3DataSourceConfiguration)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && this.hasInclusionPrefixes() == other.hasInclusionPrefixes() && Objects.equals(this.inclusionPrefixes(), other.inclusionPrefixes());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataSourceConfiguration").add("BucketArn", (Object)this.bucketArn()).add("InclusionPrefixes", this.hasInclusionPrefixes() ? this.inclusionPrefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "inclusionPrefixes": {
                return Optional.ofNullable(clazz.cast(this.inclusionPrefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DataSourceConfiguration, T> g) {
        return obj -> g.apply((S3DataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private List<String> inclusionPrefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSourceConfiguration model) {
            this.bucketArn(model.bucketArn);
            this.inclusionPrefixes(model.inclusionPrefixes);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final Collection<String> getInclusionPrefixes() {
            if (this.inclusionPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPrefixes;
        }

        public final void setInclusionPrefixes(Collection<String> inclusionPrefixes) {
            this.inclusionPrefixes = S3PrefixesCopier.copy(inclusionPrefixes);
        }

        @Override
        public final Builder inclusionPrefixes(Collection<String> inclusionPrefixes) {
            this.inclusionPrefixes = S3PrefixesCopier.copy(inclusionPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPrefixes(String ... inclusionPrefixes) {
            this.inclusionPrefixes(Arrays.asList(inclusionPrefixes));
            return this;
        }

        public S3DataSourceConfiguration build() {
            return new S3DataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataSourceConfiguration> {
        public Builder bucketArn(String var1);

        public Builder inclusionPrefixes(Collection<String> var1);

        public Builder inclusionPrefixes(String ... var1);
    }
}

