/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GuardrailStatus {
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    VERSIONING("VERSIONING"),
    READY("READY"),
    FAILED("FAILED"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GuardrailStatus> VALUE_MAP;
    private final String value;

    private GuardrailStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GuardrailStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GuardrailStatus> knownValues() {
        EnumSet<GuardrailStatus> knownValues = EnumSet.allOf(GuardrailStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GuardrailStatus.class, GuardrailStatus::toString);
    }
}

