/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.EvaluationSummary;
import software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse;

public class ListEvaluationJobsPublisher
implements SdkPublisher<ListEvaluationJobsResponse> {
    private final BedrockAsyncClient client;
    private final ListEvaluationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEvaluationJobsPublisher(BedrockAsyncClient client, ListEvaluationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEvaluationJobsPublisher(BedrockAsyncClient client, ListEvaluationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEvaluationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEvaluationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationSummary> jobSummaries() {
        Function<ListEvaluationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEvaluationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEvaluationJobsResponseFetcher
    implements AsyncPageFetcher<ListEvaluationJobsResponse> {
        private ListEvaluationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEvaluationJobsResponse> nextPage(ListEvaluationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluationJobsPublisher.this.client.listEvaluationJobs(ListEvaluationJobsPublisher.this.firstRequest);
            }
            return ListEvaluationJobsPublisher.this.client.listEvaluationJobs((ListEvaluationJobsRequest)((Object)ListEvaluationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

