/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelCustomization {
    FINE_TUNING("FINE_TUNING"),
    CONTINUED_PRE_TRAINING("CONTINUED_PRE_TRAINING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelCustomization> VALUE_MAP;
    private final String value;

    private ModelCustomization(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelCustomization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelCustomization> knownValues() {
        EnumSet<ModelCustomization> knownValues = EnumSet.allOf(ModelCustomization.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelCustomization.class, ModelCustomization::toString);
    }
}

