/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.ExportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportReference> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportArn").getter(ExportReference.getter(ExportReference::exportArn)).setter(ExportReference.setter(Builder::exportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()}).build();
    private static final SdkField<String> EXPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportName").getter(ExportReference.getter(ExportReference::exportName)).setter(ExportReference.setter(Builder::exportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportName").build()}).build();
    private static final SdkField<ExportStatus> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportStatus").getter(ExportReference.getter(ExportReference::exportStatus)).setter(ExportReference.setter(Builder::exportStatus)).constructor(ExportStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD, EXPORT_NAME_FIELD, EXPORT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExportArn", EXPORT_ARN_FIELD);
            this.put("ExportName", EXPORT_NAME_FIELD);
            this.put("ExportStatus", EXPORT_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String exportArn;
    private final String exportName;
    private final ExportStatus exportStatus;

    private ExportReference(BuilderImpl builder) {
        this.exportArn = builder.exportArn;
        this.exportName = builder.exportName;
        this.exportStatus = builder.exportStatus;
    }

    public final String exportArn() {
        return this.exportArn;
    }

    public final String exportName() {
        return this.exportName;
    }

    public final ExportStatus exportStatus() {
        return this.exportStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportReference)) {
            return false;
        }
        ExportReference other = (ExportReference)obj;
        return Objects.equals(this.exportArn(), other.exportArn()) && Objects.equals(this.exportName(), other.exportName()) && Objects.equals(this.exportStatus(), other.exportStatus());
    }

    public final String toString() {
        return ToString.builder((String)"ExportReference").add("ExportArn", (Object)this.exportArn()).add("ExportName", (Object)this.exportName()).add("ExportStatus", (Object)this.exportStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportArn": {
                return Optional.ofNullable(clazz.cast(this.exportArn()));
            }
            case "ExportName": {
                return Optional.ofNullable(clazz.cast(this.exportName()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportReference, T> g) {
        return obj -> g.apply((ExportReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportArn;
        private String exportName;
        private ExportStatus exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportReference model) {
            this.exportArn(model.exportArn);
            this.exportName(model.exportName);
            this.exportStatus(model.exportStatus);
        }

        public final String getExportArn() {
            return this.exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final String getExportName() {
            return this.exportName;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final ExportStatus.Builder getExportStatus() {
            return this.exportStatus != null ? this.exportStatus.toBuilder() : null;
        }

        public final void setExportStatus(ExportStatus.BuilderImpl exportStatus) {
            this.exportStatus = exportStatus != null ? exportStatus.build() : null;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        public ExportReference build() {
            return new ExportReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportReference> {
        public Builder exportArn(String var1);

        public Builder exportName(String var1);

        public Builder exportStatus(ExportStatus var1);

        default public Builder exportStatus(Consumer<ExportStatus.Builder> exportStatus) {
            return this.exportStatus((ExportStatus)((ExportStatus.Builder)ExportStatus.builder().applyMutation(exportStatus)).build());
        }
    }
}

