/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.Export;
import software.amazon.awssdk.services.bcmdataexports.model.ExportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExportResponse
extends BcmDataExportsResponse
implements ToCopyableBuilder<Builder, GetExportResponse> {
    private static final SdkField<Export> EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Export").getter(GetExportResponse.getter(GetExportResponse::export)).setter(GetExportResponse.setter(Builder::export)).constructor(Export::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Export").build()}).build();
    private static final SdkField<ExportStatus> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportStatus").getter(GetExportResponse.getter(GetExportResponse::exportStatus)).setter(GetExportResponse.setter(Builder::exportStatus)).constructor(ExportStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD, EXPORT_STATUS_FIELD));
    private final Export export;
    private final ExportStatus exportStatus;

    private GetExportResponse(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.exportStatus = builder.exportStatus;
    }

    public final Export export() {
        return this.export;
    }

    public final ExportStatus exportStatus() {
        return this.exportStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.export());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportResponse)) {
            return false;
        }
        GetExportResponse other = (GetExportResponse)((Object)obj);
        return Objects.equals(this.export(), other.export()) && Objects.equals(this.exportStatus(), other.exportStatus());
    }

    public final String toString() {
        return ToString.builder((String)"GetExportResponse").add("Export", (Object)this.export()).add("ExportStatus", (Object)this.exportStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Export": {
                return Optional.ofNullable(clazz.cast(this.export()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportResponse, T> g) {
        return obj -> g.apply((GetExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsResponse.BuilderImpl
    implements Builder {
        private Export export;
        private ExportStatus exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportResponse model) {
            super(model);
            this.export(model.export);
            this.exportStatus(model.exportStatus);
        }

        public final Export.Builder getExport() {
            return this.export != null ? this.export.toBuilder() : null;
        }

        public final void setExport(Export.BuilderImpl export) {
            this.export = export != null ? export.build() : null;
        }

        @Override
        public final Builder export(Export export) {
            this.export = export;
            return this;
        }

        public final ExportStatus.Builder getExportStatus() {
            return this.exportStatus != null ? this.exportStatus.toBuilder() : null;
        }

        public final void setExportStatus(ExportStatus.BuilderImpl exportStatus) {
            this.exportStatus = exportStatus != null ? exportStatus.build() : null;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public GetExportResponse build() {
            return new GetExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BcmDataExportsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExportResponse> {
        public Builder export(Export var1);

        default public Builder export(Consumer<Export.Builder> export) {
            return this.export((Export)((Export.Builder)Export.builder().applyMutation(export)).build());
        }

        public Builder exportStatus(ExportStatus var1);

        default public Builder exportStatus(Consumer<ExportStatus.Builder> exportStatus) {
            return this.exportStatus((ExportStatus)((ExportStatus.Builder)ExportStatus.builder().applyMutation(exportStatus)).build());
        }
    }
}

