/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionStatusReason {
    INSUFFICIENT_PERMISSION("INSUFFICIENT_PERMISSION"),
    BILL_OWNER_CHANGED("BILL_OWNER_CHANGED"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionStatusReason> VALUE_MAP;
    private final String value;

    private ExecutionStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionStatusReason> knownValues() {
        EnumSet<ExecutionStatusReason> knownValues = EnumSet.allOf(ExecutionStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionStatusReason.class, ExecutionStatusReason::toString);
    }
}

