/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionStatusCode {
    INITIATION_IN_PROCESS("INITIATION_IN_PROCESS"),
    QUERY_QUEUED("QUERY_QUEUED"),
    QUERY_IN_PROCESS("QUERY_IN_PROCESS"),
    QUERY_FAILURE("QUERY_FAILURE"),
    DELIVERY_IN_PROCESS("DELIVERY_IN_PROCESS"),
    DELIVERY_SUCCESS("DELIVERY_SUCCESS"),
    DELIVERY_FAILURE("DELIVERY_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionStatusCode> VALUE_MAP;
    private final String value;

    private ExecutionStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionStatusCode> knownValues() {
        EnumSet<ExecutionStatusCode> knownValues = EnumSet.allOf(ExecutionStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionStatusCode.class, ExecutionStatusCode::toString);
    }
}

