/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.ExecutionStatusReason;
import software.amazon.awssdk.services.bcmdataexports.model.ExportStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportStatus> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ExportStatus.getter(ExportStatus::createdAt)).setter(ExportStatus.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_REFRESHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastRefreshedAt").getter(ExportStatus.getter(ExportStatus::lastRefreshedAt)).setter(ExportStatus.setter(Builder::lastRefreshedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRefreshedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(ExportStatus.getter(ExportStatus::lastUpdatedAt)).setter(ExportStatus.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(ExportStatus.getter(ExportStatus::statusCodeAsString)).setter(ExportStatus.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ExportStatus.getter(ExportStatus::statusReasonAsString)).setter(ExportStatus.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, LAST_REFRESHED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_CODE_FIELD, STATUS_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final Instant lastRefreshedAt;
    private final Instant lastUpdatedAt;
    private final String statusCode;
    private final String statusReason;

    private ExportStatus(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.lastRefreshedAt = builder.lastRefreshedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.statusCode = builder.statusCode;
        this.statusReason = builder.statusReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastRefreshedAt() {
        return this.lastRefreshedAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final ExportStatusCode statusCode() {
        return ExportStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final ExecutionStatusReason statusReason() {
        return ExecutionStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStatus)) {
            return false;
        }
        ExportStatus other = (ExportStatus)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastRefreshedAt(), other.lastRefreshedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportStatus").add("CreatedAt", (Object)this.createdAt()).add("LastRefreshedAt", (Object)this.lastRefreshedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusReason", (Object)this.statusReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastRefreshedAt": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshedAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportStatus, T> g) {
        return obj -> g.apply((ExportStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private Instant lastRefreshedAt;
        private Instant lastUpdatedAt;
        private String statusCode;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStatus model) {
            this.createdAt(model.createdAt);
            this.lastRefreshedAt(model.lastRefreshedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.statusCode(model.statusCode);
            this.statusReason(model.statusReason);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastRefreshedAt() {
            return this.lastRefreshedAt;
        }

        public final void setLastRefreshedAt(Instant lastRefreshedAt) {
            this.lastRefreshedAt = lastRefreshedAt;
        }

        @Override
        public final Builder lastRefreshedAt(Instant lastRefreshedAt) {
            this.lastRefreshedAt = lastRefreshedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ExportStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ExecutionStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public ExportStatus build() {
            return new ExportStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportStatus> {
        public Builder createdAt(Instant var1);

        public Builder lastRefreshedAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ExportStatusCode var1);

        public Builder statusReason(String var1);

        public Builder statusReason(ExecutionStatusReason var1);
    }
}

