/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmdashboards.model.CostAndUsageQuery;
import software.amazon.awssdk.services.bcmdashboards.model.ReservationCoverageQuery;
import software.amazon.awssdk.services.bcmdashboards.model.ReservationUtilizationQuery;
import software.amazon.awssdk.services.bcmdashboards.model.SavingsPlansCoverageQuery;
import software.amazon.awssdk.services.bcmdashboards.model.SavingsPlansUtilizationQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryParameters> {
    private static final SdkField<CostAndUsageQuery> COST_AND_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costAndUsage").getter(QueryParameters.getter(QueryParameters::costAndUsage)).setter(QueryParameters.setter(Builder::costAndUsage)).constructor(CostAndUsageQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costAndUsage").build()}).build();
    private static final SdkField<SavingsPlansCoverageQuery> SAVINGS_PLANS_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsPlansCoverage").getter(QueryParameters.getter(QueryParameters::savingsPlansCoverage)).setter(QueryParameters.setter(Builder::savingsPlansCoverage)).constructor(SavingsPlansCoverageQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlansCoverage").build()}).build();
    private static final SdkField<SavingsPlansUtilizationQuery> SAVINGS_PLANS_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsPlansUtilization").getter(QueryParameters.getter(QueryParameters::savingsPlansUtilization)).setter(QueryParameters.setter(Builder::savingsPlansUtilization)).constructor(SavingsPlansUtilizationQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlansUtilization").build()}).build();
    private static final SdkField<ReservationCoverageQuery> RESERVATION_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reservationCoverage").getter(QueryParameters.getter(QueryParameters::reservationCoverage)).setter(QueryParameters.setter(Builder::reservationCoverage)).constructor(ReservationCoverageQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationCoverage").build()}).build();
    private static final SdkField<ReservationUtilizationQuery> RESERVATION_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reservationUtilization").getter(QueryParameters.getter(QueryParameters::reservationUtilization)).setter(QueryParameters.setter(Builder::reservationUtilization)).constructor(ReservationUtilizationQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationUtilization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_AND_USAGE_FIELD, SAVINGS_PLANS_COVERAGE_FIELD, SAVINGS_PLANS_UTILIZATION_FIELD, RESERVATION_COVERAGE_FIELD, RESERVATION_UTILIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CostAndUsageQuery costAndUsage;
    private final SavingsPlansCoverageQuery savingsPlansCoverage;
    private final SavingsPlansUtilizationQuery savingsPlansUtilization;
    private final ReservationCoverageQuery reservationCoverage;
    private final ReservationUtilizationQuery reservationUtilization;
    private final Type type;

    private QueryParameters(BuilderImpl builder) {
        this.costAndUsage = builder.costAndUsage;
        this.savingsPlansCoverage = builder.savingsPlansCoverage;
        this.savingsPlansUtilization = builder.savingsPlansUtilization;
        this.reservationCoverage = builder.reservationCoverage;
        this.reservationUtilization = builder.reservationUtilization;
        this.type = builder.type;
    }

    public final CostAndUsageQuery costAndUsage() {
        return this.costAndUsage;
    }

    public final SavingsPlansCoverageQuery savingsPlansCoverage() {
        return this.savingsPlansCoverage;
    }

    public final SavingsPlansUtilizationQuery savingsPlansUtilization() {
        return this.savingsPlansUtilization;
    }

    public final ReservationCoverageQuery reservationCoverage() {
        return this.reservationCoverage;
    }

    public final ReservationUtilizationQuery reservationUtilization() {
        return this.reservationUtilization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costAndUsage());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationUtilization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryParameters)) {
            return false;
        }
        QueryParameters other = (QueryParameters)obj;
        return Objects.equals(this.costAndUsage(), other.costAndUsage()) && Objects.equals(this.savingsPlansCoverage(), other.savingsPlansCoverage()) && Objects.equals(this.savingsPlansUtilization(), other.savingsPlansUtilization()) && Objects.equals(this.reservationCoverage(), other.reservationCoverage()) && Objects.equals(this.reservationUtilization(), other.reservationUtilization());
    }

    public final String toString() {
        return ToString.builder((String)"QueryParameters").add("CostAndUsage", (Object)this.costAndUsage()).add("SavingsPlansCoverage", (Object)this.savingsPlansCoverage()).add("SavingsPlansUtilization", (Object)this.savingsPlansUtilization()).add("ReservationCoverage", (Object)this.reservationCoverage()).add("ReservationUtilization", (Object)this.reservationUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "costAndUsage": {
                return Optional.ofNullable(clazz.cast(this.costAndUsage()));
            }
            case "savingsPlansCoverage": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansCoverage()));
            }
            case "savingsPlansUtilization": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansUtilization()));
            }
            case "reservationCoverage": {
                return Optional.ofNullable(clazz.cast(this.reservationCoverage()));
            }
            case "reservationUtilization": {
                return Optional.ofNullable(clazz.cast(this.reservationUtilization()));
            }
        }
        return Optional.empty();
    }

    public static QueryParameters fromCostAndUsage(CostAndUsageQuery costAndUsage) {
        return (QueryParameters)QueryParameters.builder().costAndUsage(costAndUsage).build();
    }

    public static QueryParameters fromCostAndUsage(Consumer<CostAndUsageQuery.Builder> costAndUsage) {
        CostAndUsageQuery.Builder builder = CostAndUsageQuery.builder();
        costAndUsage.accept(builder);
        return QueryParameters.fromCostAndUsage((CostAndUsageQuery)builder.build());
    }

    public static QueryParameters fromSavingsPlansCoverage(SavingsPlansCoverageQuery savingsPlansCoverage) {
        return (QueryParameters)QueryParameters.builder().savingsPlansCoverage(savingsPlansCoverage).build();
    }

    public static QueryParameters fromSavingsPlansCoverage(Consumer<SavingsPlansCoverageQuery.Builder> savingsPlansCoverage) {
        SavingsPlansCoverageQuery.Builder builder = SavingsPlansCoverageQuery.builder();
        savingsPlansCoverage.accept(builder);
        return QueryParameters.fromSavingsPlansCoverage((SavingsPlansCoverageQuery)builder.build());
    }

    public static QueryParameters fromSavingsPlansUtilization(SavingsPlansUtilizationQuery savingsPlansUtilization) {
        return (QueryParameters)QueryParameters.builder().savingsPlansUtilization(savingsPlansUtilization).build();
    }

    public static QueryParameters fromSavingsPlansUtilization(Consumer<SavingsPlansUtilizationQuery.Builder> savingsPlansUtilization) {
        SavingsPlansUtilizationQuery.Builder builder = SavingsPlansUtilizationQuery.builder();
        savingsPlansUtilization.accept(builder);
        return QueryParameters.fromSavingsPlansUtilization((SavingsPlansUtilizationQuery)builder.build());
    }

    public static QueryParameters fromReservationCoverage(ReservationCoverageQuery reservationCoverage) {
        return (QueryParameters)QueryParameters.builder().reservationCoverage(reservationCoverage).build();
    }

    public static QueryParameters fromReservationCoverage(Consumer<ReservationCoverageQuery.Builder> reservationCoverage) {
        ReservationCoverageQuery.Builder builder = ReservationCoverageQuery.builder();
        reservationCoverage.accept(builder);
        return QueryParameters.fromReservationCoverage((ReservationCoverageQuery)builder.build());
    }

    public static QueryParameters fromReservationUtilization(ReservationUtilizationQuery reservationUtilization) {
        return (QueryParameters)QueryParameters.builder().reservationUtilization(reservationUtilization).build();
    }

    public static QueryParameters fromReservationUtilization(Consumer<ReservationUtilizationQuery.Builder> reservationUtilization) {
        ReservationUtilizationQuery.Builder builder = ReservationUtilizationQuery.builder();
        reservationUtilization.accept(builder);
        return QueryParameters.fromReservationUtilization((ReservationUtilizationQuery)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("costAndUsage", COST_AND_USAGE_FIELD);
        map.put("savingsPlansCoverage", SAVINGS_PLANS_COVERAGE_FIELD);
        map.put("savingsPlansUtilization", SAVINGS_PLANS_UTILIZATION_FIELD);
        map.put("reservationCoverage", RESERVATION_COVERAGE_FIELD);
        map.put("reservationUtilization", RESERVATION_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryParameters, T> g) {
        return obj -> g.apply((QueryParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        COST_AND_USAGE,
        SAVINGS_PLANS_COVERAGE,
        SAVINGS_PLANS_UTILIZATION,
        RESERVATION_COVERAGE,
        RESERVATION_UTILIZATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CostAndUsageQuery costAndUsage;
        private SavingsPlansCoverageQuery savingsPlansCoverage;
        private SavingsPlansUtilizationQuery savingsPlansUtilization;
        private ReservationCoverageQuery reservationCoverage;
        private ReservationUtilizationQuery reservationUtilization;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(QueryParameters model) {
            this.costAndUsage(model.costAndUsage);
            this.savingsPlansCoverage(model.savingsPlansCoverage);
            this.savingsPlansUtilization(model.savingsPlansUtilization);
            this.reservationCoverage(model.reservationCoverage);
            this.reservationUtilization(model.reservationUtilization);
        }

        public final CostAndUsageQuery.Builder getCostAndUsage() {
            return this.costAndUsage != null ? this.costAndUsage.toBuilder() : null;
        }

        public final void setCostAndUsage(CostAndUsageQuery.BuilderImpl costAndUsage) {
            CostAndUsageQuery oldValue = this.costAndUsage;
            this.costAndUsage = costAndUsage != null ? costAndUsage.build() : null;
            this.handleUnionValueChange(Type.COST_AND_USAGE, oldValue, this.costAndUsage);
        }

        @Override
        public final Builder costAndUsage(CostAndUsageQuery costAndUsage) {
            CostAndUsageQuery oldValue = this.costAndUsage;
            this.costAndUsage = costAndUsage;
            this.handleUnionValueChange(Type.COST_AND_USAGE, oldValue, this.costAndUsage);
            return this;
        }

        public final SavingsPlansCoverageQuery.Builder getSavingsPlansCoverage() {
            return this.savingsPlansCoverage != null ? this.savingsPlansCoverage.toBuilder() : null;
        }

        public final void setSavingsPlansCoverage(SavingsPlansCoverageQuery.BuilderImpl savingsPlansCoverage) {
            SavingsPlansCoverageQuery oldValue = this.savingsPlansCoverage;
            this.savingsPlansCoverage = savingsPlansCoverage != null ? savingsPlansCoverage.build() : null;
            this.handleUnionValueChange(Type.SAVINGS_PLANS_COVERAGE, oldValue, this.savingsPlansCoverage);
        }

        @Override
        public final Builder savingsPlansCoverage(SavingsPlansCoverageQuery savingsPlansCoverage) {
            SavingsPlansCoverageQuery oldValue = this.savingsPlansCoverage;
            this.savingsPlansCoverage = savingsPlansCoverage;
            this.handleUnionValueChange(Type.SAVINGS_PLANS_COVERAGE, oldValue, this.savingsPlansCoverage);
            return this;
        }

        public final SavingsPlansUtilizationQuery.Builder getSavingsPlansUtilization() {
            return this.savingsPlansUtilization != null ? this.savingsPlansUtilization.toBuilder() : null;
        }

        public final void setSavingsPlansUtilization(SavingsPlansUtilizationQuery.BuilderImpl savingsPlansUtilization) {
            SavingsPlansUtilizationQuery oldValue = this.savingsPlansUtilization;
            this.savingsPlansUtilization = savingsPlansUtilization != null ? savingsPlansUtilization.build() : null;
            this.handleUnionValueChange(Type.SAVINGS_PLANS_UTILIZATION, oldValue, this.savingsPlansUtilization);
        }

        @Override
        public final Builder savingsPlansUtilization(SavingsPlansUtilizationQuery savingsPlansUtilization) {
            SavingsPlansUtilizationQuery oldValue = this.savingsPlansUtilization;
            this.savingsPlansUtilization = savingsPlansUtilization;
            this.handleUnionValueChange(Type.SAVINGS_PLANS_UTILIZATION, oldValue, this.savingsPlansUtilization);
            return this;
        }

        public final ReservationCoverageQuery.Builder getReservationCoverage() {
            return this.reservationCoverage != null ? this.reservationCoverage.toBuilder() : null;
        }

        public final void setReservationCoverage(ReservationCoverageQuery.BuilderImpl reservationCoverage) {
            ReservationCoverageQuery oldValue = this.reservationCoverage;
            this.reservationCoverage = reservationCoverage != null ? reservationCoverage.build() : null;
            this.handleUnionValueChange(Type.RESERVATION_COVERAGE, oldValue, this.reservationCoverage);
        }

        @Override
        public final Builder reservationCoverage(ReservationCoverageQuery reservationCoverage) {
            ReservationCoverageQuery oldValue = this.reservationCoverage;
            this.reservationCoverage = reservationCoverage;
            this.handleUnionValueChange(Type.RESERVATION_COVERAGE, oldValue, this.reservationCoverage);
            return this;
        }

        public final ReservationUtilizationQuery.Builder getReservationUtilization() {
            return this.reservationUtilization != null ? this.reservationUtilization.toBuilder() : null;
        }

        public final void setReservationUtilization(ReservationUtilizationQuery.BuilderImpl reservationUtilization) {
            ReservationUtilizationQuery oldValue = this.reservationUtilization;
            this.reservationUtilization = reservationUtilization != null ? reservationUtilization.build() : null;
            this.handleUnionValueChange(Type.RESERVATION_UTILIZATION, oldValue, this.reservationUtilization);
        }

        @Override
        public final Builder reservationUtilization(ReservationUtilizationQuery reservationUtilization) {
            ReservationUtilizationQuery oldValue = this.reservationUtilization;
            this.reservationUtilization = reservationUtilization;
            this.handleUnionValueChange(Type.RESERVATION_UTILIZATION, oldValue, this.reservationUtilization);
            return this;
        }

        public QueryParameters build() {
            return new QueryParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryParameters> {
        public Builder costAndUsage(CostAndUsageQuery var1);

        default public Builder costAndUsage(Consumer<CostAndUsageQuery.Builder> costAndUsage) {
            return this.costAndUsage((CostAndUsageQuery)((CostAndUsageQuery.Builder)CostAndUsageQuery.builder().applyMutation(costAndUsage)).build());
        }

        public Builder savingsPlansCoverage(SavingsPlansCoverageQuery var1);

        default public Builder savingsPlansCoverage(Consumer<SavingsPlansCoverageQuery.Builder> savingsPlansCoverage) {
            return this.savingsPlansCoverage((SavingsPlansCoverageQuery)((SavingsPlansCoverageQuery.Builder)SavingsPlansCoverageQuery.builder().applyMutation(savingsPlansCoverage)).build());
        }

        public Builder savingsPlansUtilization(SavingsPlansUtilizationQuery var1);

        default public Builder savingsPlansUtilization(Consumer<SavingsPlansUtilizationQuery.Builder> savingsPlansUtilization) {
            return this.savingsPlansUtilization((SavingsPlansUtilizationQuery)((SavingsPlansUtilizationQuery.Builder)SavingsPlansUtilizationQuery.builder().applyMutation(savingsPlansUtilization)).build());
        }

        public Builder reservationCoverage(ReservationCoverageQuery var1);

        default public Builder reservationCoverage(Consumer<ReservationCoverageQuery.Builder> reservationCoverage) {
            return this.reservationCoverage((ReservationCoverageQuery)((ReservationCoverageQuery.Builder)ReservationCoverageQuery.builder().applyMutation(reservationCoverage)).build());
        }

        public Builder reservationUtilization(ReservationUtilizationQuery var1);

        default public Builder reservationUtilization(Consumer<ReservationUtilizationQuery.Builder> reservationUtilization) {
            return this.reservationUtilization((ReservationUtilizationQuery)((ReservationUtilizationQuery.Builder)ReservationUtilizationQuery.builder().applyMutation(reservationUtilization)).build());
        }
    }
}

