/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Granularity {
    HOURLY("HOURLY"),
    DAILY("DAILY"),
    MONTHLY("MONTHLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Granularity> VALUE_MAP;
    private final String value;

    private Granularity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Granularity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Granularity> knownValues() {
        EnumSet<Granularity> knownValues = EnumSet.allOf(Granularity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Granularity.class, Granularity::toString);
    }
}

