/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bcmdashboards.BcmDashboardsClientBuilder;
import software.amazon.awssdk.services.bcmdashboards.BcmDashboardsServiceClientConfiguration;
import software.amazon.awssdk.services.bcmdashboards.DefaultBcmDashboardsClientBuilder;
import software.amazon.awssdk.services.bcmdashboards.model.AccessDeniedException;
import software.amazon.awssdk.services.bcmdashboards.model.BcmDashboardsException;
import software.amazon.awssdk.services.bcmdashboards.model.CreateDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.CreateDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.GetDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.GetDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.bcmdashboards.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.bcmdashboards.model.InternalServerException;
import software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsRequest;
import software.amazon.awssdk.services.bcmdashboards.model.ListDashboardsResponse;
import software.amazon.awssdk.services.bcmdashboards.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmdashboards.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmdashboards.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bcmdashboards.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bcmdashboards.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmdashboards.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmdashboards.model.ThrottlingException;
import software.amazon.awssdk.services.bcmdashboards.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmdashboards.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmdashboards.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.bcmdashboards.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.bcmdashboards.model.ValidationException;
import software.amazon.awssdk.services.bcmdashboards.paginators.ListDashboardsIterable;

@SdkPublicApi
@ThreadSafe
public interface BcmDashboardsClient
extends AwsClient {
    public static final String SERVICE_NAME = "bcm-dashboards";
    public static final String SERVICE_METADATA_ID = "bcm-dashboards";

    default public CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public CreateDashboardResponse createDashboard(Consumer<CreateDashboardRequest.Builder> createDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.createDashboard((CreateDashboardRequest)((Object)((CreateDashboardRequest.Builder)CreateDashboardRequest.builder().applyMutation(createDashboardRequest)).build()));
    }

    default public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDashboardResponse deleteDashboard(Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.deleteDashboard((DeleteDashboardRequest)((Object)((DeleteDashboardRequest.Builder)DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest)).build()));
    }

    default public GetDashboardResponse getDashboard(GetDashboardRequest getDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public GetDashboardResponse getDashboard(Consumer<GetDashboardRequest.Builder> getDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.getDashboard((GetDashboardRequest)((Object)((GetDashboardRequest.Builder)GetDashboardRequest.builder().applyMutation(getDashboardRequest)).build()));
    }

    default public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.getResourcePolicy((GetResourcePolicyRequest)((Object)((GetResourcePolicyRequest.Builder)GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest)).build()));
    }

    default public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public ListDashboardsResponse listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.listDashboards((ListDashboardsRequest)((Object)((ListDashboardsRequest.Builder)ListDashboardsRequest.builder().applyMutation(listDashboardsRequest)).build()));
    }

    default public ListDashboardsIterable listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return new ListDashboardsIterable(this, listDashboardsRequest);
    }

    default public ListDashboardsIterable listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.listDashboardsPaginator((ListDashboardsRequest)((Object)((ListDashboardsRequest.Builder)ListDashboardsRequest.builder().applyMutation(listDashboardsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateDashboardResponse updateDashboard(UpdateDashboardRequest updateDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDashboardResponse updateDashboard(Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest) throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, BcmDashboardsException {
        return this.updateDashboard((UpdateDashboardRequest)((Object)((UpdateDashboardRequest.Builder)UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest)).build()));
    }

    public static BcmDashboardsClient create() {
        return (BcmDashboardsClient)BcmDashboardsClient.builder().build();
    }

    public static BcmDashboardsClientBuilder builder() {
        return new DefaultBcmDashboardsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"bcm-dashboards");
    }

    default public BcmDashboardsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

