/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdashboards.model.DateTimeRange;
import software.amazon.awssdk.services.bcmdashboards.model.Expression;
import software.amazon.awssdk.services.bcmdashboards.model.Granularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansUtilizationQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansUtilizationQuery> {
    private static final SdkField<DateTimeRange> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeRange").getter(SavingsPlansUtilizationQuery.getter(SavingsPlansUtilizationQuery::timeRange)).setter(SavingsPlansUtilizationQuery.setter(Builder::timeRange)).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("granularity").getter(SavingsPlansUtilizationQuery.getter(SavingsPlansUtilizationQuery::granularityAsString)).setter(SavingsPlansUtilizationQuery.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granularity").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(SavingsPlansUtilizationQuery.getter(SavingsPlansUtilizationQuery::filter)).setter(SavingsPlansUtilizationQuery.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD, GRANULARITY_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SavingsPlansUtilizationQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DateTimeRange timeRange;
    private final String granularity;
    private final Expression filter;

    private SavingsPlansUtilizationQuery(BuilderImpl builder) {
        this.timeRange = builder.timeRange;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
    }

    public final DateTimeRange timeRange() {
        return this.timeRange;
    }

    public final Granularity granularity() {
        return Granularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final Expression filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilizationQuery)) {
            return false;
        }
        SavingsPlansUtilizationQuery other = (SavingsPlansUtilizationQuery)obj;
        return Objects.equals(this.timeRange(), other.timeRange()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansUtilizationQuery").add("TimeRange", (Object)this.timeRange()).add("Granularity", (Object)this.granularityAsString()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRange()));
            }
            case "granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeRange", TIME_RANGE_FIELD);
        map.put("granularity", GRANULARITY_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilizationQuery, T> g) {
        return obj -> g.apply((SavingsPlansUtilizationQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateTimeRange timeRange;
        private String granularity;
        private Expression filter;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilizationQuery model) {
            this.timeRange(model.timeRange);
            this.granularity(model.granularity);
            this.filter(model.filter);
        }

        public final DateTimeRange.Builder getTimeRange() {
            return this.timeRange != null ? this.timeRange.toBuilder() : null;
        }

        public final void setTimeRange(DateTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(DateTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public SavingsPlansUtilizationQuery build() {
            return new SavingsPlansUtilizationQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansUtilizationQuery> {
        public Builder timeRange(DateTimeRange var1);

        default public Builder timeRange(Consumer<DateTimeRange.Builder> timeRange) {
            return this.timeRange((DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation(timeRange)).build());
        }

        public Builder granularity(String var1);

        public Builder granularity(Granularity var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }
    }
}

