/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricName {
    AMORTIZED_COST("AmortizedCost"),
    BLENDED_COST("BlendedCost"),
    NET_AMORTIZED_COST("NetAmortizedCost"),
    NET_UNBLENDED_COST("NetUnblendedCost"),
    NORMALIZED_USAGE_AMOUNT("NormalizedUsageAmount"),
    UNBLENDED_COST("UnblendedCost"),
    USAGE_QUANTITY("UsageQuantity"),
    SPEND_COVERED_BY_SAVINGS_PLANS("SpendCoveredBySavingsPlans"),
    HOUR("Hour"),
    UNIT("Unit"),
    COST("Cost"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricName> VALUE_MAP;
    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricName> knownValues() {
        EnumSet<MetricName> knownValues = EnumSet.allOf(MetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricName.class, MetricName::toString);
    }
}

