/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.CRType;
import software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeResource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComputeResource.getter(ComputeResource::typeAsString)).setter(ComputeResource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Integer> MINV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ComputeResource.getter(ComputeResource::minvCpus)).setter(ComputeResource.setter(Builder::minvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minvCpus").build()}).build();
    private static final SdkField<Integer> MAXV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ComputeResource.getter(ComputeResource::maxvCpus)).setter(ComputeResource.setter(Builder::maxvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxvCpus").build()}).build();
    private static final SdkField<Integer> DESIREDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ComputeResource.getter(ComputeResource::desiredvCpus)).setter(ComputeResource.setter(Builder::desiredvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredvCpus").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ComputeResource.getter(ComputeResource::instanceTypes)).setter(ComputeResource.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComputeResource.getter(ComputeResource::imageId)).setter(ComputeResource.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ComputeResource.getter(ComputeResource::subnets)).setter(ComputeResource.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ComputeResource.getter(ComputeResource::securityGroupIds)).setter(ComputeResource.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComputeResource.getter(ComputeResource::ec2KeyPair)).setter(ComputeResource.setter(Builder::ec2KeyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyPair").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComputeResource.getter(ComputeResource::instanceRole)).setter(ComputeResource.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ComputeResource.getter(ComputeResource::tags)).setter(ComputeResource.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComputeResource.getter(ComputeResource::placementGroup)).setter(ComputeResource.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroup").build()}).build();
    private static final SdkField<Integer> BID_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ComputeResource.getter(ComputeResource::bidPercentage)).setter(ComputeResource.setter(Builder::bidPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bidPercentage").build()}).build();
    private static final SdkField<String> SPOT_IAM_FLEET_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComputeResource.getter(ComputeResource::spotIamFleetRole)).setter(ComputeResource.setter(Builder::spotIamFleetRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotIamFleetRole").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ComputeResource.getter(ComputeResource::launchTemplate)).setter(ComputeResource.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MINV_CPUS_FIELD, MAXV_CPUS_FIELD, DESIREDV_CPUS_FIELD, INSTANCE_TYPES_FIELD, IMAGE_ID_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, EC2_KEY_PAIR_FIELD, INSTANCE_ROLE_FIELD, TAGS_FIELD, PLACEMENT_GROUP_FIELD, BID_PERCENTAGE_FIELD, SPOT_IAM_FLEET_ROLE_FIELD, LAUNCH_TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Integer minvCpus;
    private final Integer maxvCpus;
    private final Integer desiredvCpus;
    private final List<String> instanceTypes;
    private final String imageId;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String ec2KeyPair;
    private final String instanceRole;
    private final Map<String, String> tags;
    private final String placementGroup;
    private final Integer bidPercentage;
    private final String spotIamFleetRole;
    private final LaunchTemplateSpecification launchTemplate;

    private ComputeResource(BuilderImpl builder) {
        this.type = builder.type;
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.instanceTypes = builder.instanceTypes;
        this.imageId = builder.imageId;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.ec2KeyPair = builder.ec2KeyPair;
        this.instanceRole = builder.instanceRole;
        this.tags = builder.tags;
        this.placementGroup = builder.placementGroup;
        this.bidPercentage = builder.bidPercentage;
        this.spotIamFleetRole = builder.spotIamFleetRole;
        this.launchTemplate = builder.launchTemplate;
    }

    public CRType type() {
        return CRType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Integer minvCpus() {
        return this.minvCpus;
    }

    public Integer maxvCpus() {
        return this.maxvCpus;
    }

    public Integer desiredvCpus() {
        return this.desiredvCpus;
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String ec2KeyPair() {
        return this.ec2KeyPair;
    }

    public String instanceRole() {
        return this.instanceRole;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public Integer bidPercentage() {
        return this.bidPercentage;
    }

    public String spotIamFleetRole() {
        return this.spotIamFleetRole;
    }

    public LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotIamFleetRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResource)) {
            return false;
        }
        ComputeResource other = (ComputeResource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.minvCpus(), other.minvCpus()) && Objects.equals(this.maxvCpus(), other.maxvCpus()) && Objects.equals(this.desiredvCpus(), other.desiredvCpus()) && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.ec2KeyPair(), other.ec2KeyPair()) && Objects.equals(this.instanceRole(), other.instanceRole()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.bidPercentage(), other.bidPercentage()) && Objects.equals(this.spotIamFleetRole(), other.spotIamFleetRole()) && Objects.equals(this.launchTemplate(), other.launchTemplate());
    }

    public String toString() {
        return ToString.builder((String)"ComputeResource").add("Type", (Object)this.typeAsString()).add("MinvCpus", (Object)this.minvCpus()).add("MaxvCpus", (Object)this.maxvCpus()).add("DesiredvCpus", (Object)this.desiredvCpus()).add("InstanceTypes", this.instanceTypes()).add("ImageId", (Object)this.imageId()).add("Subnets", this.subnets()).add("SecurityGroupIds", this.securityGroupIds()).add("Ec2KeyPair", (Object)this.ec2KeyPair()).add("InstanceRole", (Object)this.instanceRole()).add("Tags", this.tags()).add("PlacementGroup", (Object)this.placementGroup()).add("BidPercentage", (Object)this.bidPercentage()).add("SpotIamFleetRole", (Object)this.spotIamFleetRole()).add("LaunchTemplate", (Object)this.launchTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "minvCpus": {
                return Optional.ofNullable(clazz.cast(this.minvCpus()));
            }
            case "maxvCpus": {
                return Optional.ofNullable(clazz.cast(this.maxvCpus()));
            }
            case "desiredvCpus": {
                return Optional.ofNullable(clazz.cast(this.desiredvCpus()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "ec2KeyPair": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyPair()));
            }
            case "instanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "placementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "bidPercentage": {
                return Optional.ofNullable(clazz.cast(this.bidPercentage()));
            }
            case "spotIamFleetRole": {
                return Optional.ofNullable(clazz.cast(this.spotIamFleetRole()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeResource, T> g) {
        return obj -> g.apply((ComputeResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer minvCpus;
        private Integer maxvCpus;
        private Integer desiredvCpus;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String ec2KeyPair;
        private String instanceRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String placementGroup;
        private Integer bidPercentage;
        private String spotIamFleetRole;
        private LaunchTemplateSpecification launchTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResource model) {
            this.type(model.type);
            this.minvCpus(model.minvCpus);
            this.maxvCpus(model.maxvCpus);
            this.desiredvCpus(model.desiredvCpus);
            this.instanceTypes(model.instanceTypes);
            this.imageId(model.imageId);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.ec2KeyPair(model.ec2KeyPair);
            this.instanceRole(model.instanceRole);
            this.tags(model.tags);
            this.placementGroup(model.placementGroup);
            this.bidPercentage(model.bidPercentage);
            this.spotIamFleetRole(model.spotIamFleetRole);
            this.launchTemplate(model.launchTemplate);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getMinvCpus() {
            return this.minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        public final Integer getMaxvCpus() {
            return this.maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        public final Integer getDesiredvCpus() {
            return this.desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getEc2KeyPair() {
            return this.ec2KeyPair;
        }

        @Override
        public final Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public final void setEc2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final Integer getBidPercentage() {
            return this.bidPercentage;
        }

        @Override
        public final Builder bidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public final void setBidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
        }

        public final String getSpotIamFleetRole() {
            return this.spotIamFleetRole;
        }

        @Override
        public final Builder spotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
            return this;
        }

        public final void setSpotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public ComputeResource build() {
            return new ComputeResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeResource> {
        public Builder type(String var1);

        public Builder type(CRType var1);

        public Builder minvCpus(Integer var1);

        public Builder maxvCpus(Integer var1);

        public Builder desiredvCpus(Integer var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder imageId(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder ec2KeyPair(String var1);

        public Builder instanceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder placementGroup(String var1);

        public Builder bidPercentage(Integer var1);

        public Builder spotIamFleetRole(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }
    }
}

