/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.CRType;
import software.amazon.awssdk.services.batch.model.CRUpdateAllocationStrategy;
import software.amazon.awssdk.services.batch.model.ComputeScalingPolicy;
import software.amazon.awssdk.services.batch.model.Ec2Configuration;
import software.amazon.awssdk.services.batch.model.Ec2ConfigurationListCopier;
import software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeResourceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeResourceUpdate> {
    private static final SdkField<Integer> MINV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minvCpus").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::minvCpus)).setter(ComputeResourceUpdate.setter(Builder::minvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minvCpus").build()}).build();
    private static final SdkField<Integer> MAXV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxvCpus").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::maxvCpus)).setter(ComputeResourceUpdate.setter(Builder::maxvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxvCpus").build()}).build();
    private static final SdkField<Integer> DESIREDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredvCpus").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::desiredvCpus)).setter(ComputeResourceUpdate.setter(Builder::desiredvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredvCpus").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::subnets)).setter(ComputeResourceUpdate.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::securityGroupIds)).setter(ComputeResourceUpdate.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allocationStrategy").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::allocationStrategyAsString)).setter(ComputeResourceUpdate.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTypes").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::instanceTypes)).setter(ComputeResourceUpdate.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2KeyPair").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::ec2KeyPair)).setter(ComputeResourceUpdate.setter(Builder::ec2KeyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyPair").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceRole").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::instanceRole)).setter(ComputeResourceUpdate.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::tags)).setter(ComputeResourceUpdate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placementGroup").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::placementGroup)).setter(ComputeResourceUpdate.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroup").build()}).build();
    private static final SdkField<Integer> BID_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("bidPercentage").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::bidPercentage)).setter(ComputeResourceUpdate.setter(Builder::bidPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bidPercentage").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchTemplate").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::launchTemplate)).setter(ComputeResourceUpdate.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final SdkField<List<Ec2Configuration>> EC2_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2Configuration").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::ec2Configuration)).setter(ComputeResourceUpdate.setter(Builder::ec2Configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Configuration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ec2Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> UPDATE_TO_LATEST_IMAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("updateToLatestImageVersion").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::updateToLatestImageVersion)).setter(ComputeResourceUpdate.setter(Builder::updateToLatestImageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateToLatestImageVersion").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::typeAsString)).setter(ComputeResourceUpdate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::imageId)).setter(ComputeResourceUpdate.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<ComputeScalingPolicy> SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingPolicy").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::scalingPolicy)).setter(ComputeResourceUpdate.setter(Builder::scalingPolicy)).constructor(ComputeScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINV_CPUS_FIELD, MAXV_CPUS_FIELD, DESIREDV_CPUS_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, ALLOCATION_STRATEGY_FIELD, INSTANCE_TYPES_FIELD, EC2_KEY_PAIR_FIELD, INSTANCE_ROLE_FIELD, TAGS_FIELD, PLACEMENT_GROUP_FIELD, BID_PERCENTAGE_FIELD, LAUNCH_TEMPLATE_FIELD, EC2_CONFIGURATION_FIELD, UPDATE_TO_LATEST_IMAGE_VERSION_FIELD, TYPE_FIELD, IMAGE_ID_FIELD, SCALING_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeResourceUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minvCpus;
    private final Integer maxvCpus;
    private final Integer desiredvCpus;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String allocationStrategy;
    private final List<String> instanceTypes;
    private final String ec2KeyPair;
    private final String instanceRole;
    private final Map<String, String> tags;
    private final String placementGroup;
    private final Integer bidPercentage;
    private final LaunchTemplateSpecification launchTemplate;
    private final List<Ec2Configuration> ec2Configuration;
    private final Boolean updateToLatestImageVersion;
    private final String type;
    private final String imageId;
    private final ComputeScalingPolicy scalingPolicy;

    private ComputeResourceUpdate(BuilderImpl builder) {
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceTypes = builder.instanceTypes;
        this.ec2KeyPair = builder.ec2KeyPair;
        this.instanceRole = builder.instanceRole;
        this.tags = builder.tags;
        this.placementGroup = builder.placementGroup;
        this.bidPercentage = builder.bidPercentage;
        this.launchTemplate = builder.launchTemplate;
        this.ec2Configuration = builder.ec2Configuration;
        this.updateToLatestImageVersion = builder.updateToLatestImageVersion;
        this.type = builder.type;
        this.imageId = builder.imageId;
        this.scalingPolicy = builder.scalingPolicy;
    }

    public final Integer minvCpus() {
        return this.minvCpus;
    }

    public final Integer maxvCpus() {
        return this.maxvCpus;
    }

    public final Integer desiredvCpus() {
        return this.desiredvCpus;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final CRUpdateAllocationStrategy allocationStrategy() {
        return CRUpdateAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public final String ec2KeyPair() {
        return this.ec2KeyPair;
    }

    public final String instanceRole() {
        return this.instanceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String placementGroup() {
        return this.placementGroup;
    }

    public final Integer bidPercentage() {
        return this.bidPercentage;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final boolean hasEc2Configuration() {
        return this.ec2Configuration != null && !(this.ec2Configuration instanceof SdkAutoConstructList);
    }

    public final List<Ec2Configuration> ec2Configuration() {
        return this.ec2Configuration;
    }

    public final Boolean updateToLatestImageVersion() {
        return this.updateToLatestImageVersion;
    }

    public final CRType type() {
        return CRType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final ComputeScalingPolicy scalingPolicy() {
        return this.scalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2Configuration() ? this.ec2Configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToLatestImageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResourceUpdate)) {
            return false;
        }
        ComputeResourceUpdate other = (ComputeResourceUpdate)obj;
        return Objects.equals(this.minvCpus(), other.minvCpus()) && Objects.equals(this.maxvCpus(), other.maxvCpus()) && Objects.equals(this.desiredvCpus(), other.desiredvCpus()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.ec2KeyPair(), other.ec2KeyPair()) && Objects.equals(this.instanceRole(), other.instanceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.bidPercentage(), other.bidPercentage()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && this.hasEc2Configuration() == other.hasEc2Configuration() && Objects.equals(this.ec2Configuration(), other.ec2Configuration()) && Objects.equals(this.updateToLatestImageVersion(), other.updateToLatestImageVersion()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.scalingPolicy(), other.scalingPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeResourceUpdate").add("MinvCpus", (Object)this.minvCpus()).add("MaxvCpus", (Object)this.maxvCpus()).add("DesiredvCpus", (Object)this.desiredvCpus()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("Ec2KeyPair", (Object)this.ec2KeyPair()).add("InstanceRole", (Object)this.instanceRole()).add("Tags", this.hasTags() ? this.tags() : null).add("PlacementGroup", (Object)this.placementGroup()).add("BidPercentage", (Object)this.bidPercentage()).add("LaunchTemplate", (Object)this.launchTemplate()).add("Ec2Configuration", this.hasEc2Configuration() ? this.ec2Configuration() : null).add("UpdateToLatestImageVersion", (Object)this.updateToLatestImageVersion()).add("Type", (Object)this.typeAsString()).add("ImageId", (Object)this.imageId()).add("ScalingPolicy", (Object)this.scalingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minvCpus": {
                return Optional.ofNullable(clazz.cast(this.minvCpus()));
            }
            case "maxvCpus": {
                return Optional.ofNullable(clazz.cast(this.maxvCpus()));
            }
            case "desiredvCpus": {
                return Optional.ofNullable(clazz.cast(this.desiredvCpus()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "allocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "ec2KeyPair": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyPair()));
            }
            case "instanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "placementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "bidPercentage": {
                return Optional.ofNullable(clazz.cast(this.bidPercentage()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "ec2Configuration": {
                return Optional.ofNullable(clazz.cast(this.ec2Configuration()));
            }
            case "updateToLatestImageVersion": {
                return Optional.ofNullable(clazz.cast(this.updateToLatestImageVersion()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "scalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("minvCpus", MINV_CPUS_FIELD);
        map.put("maxvCpus", MAXV_CPUS_FIELD);
        map.put("desiredvCpus", DESIREDV_CPUS_FIELD);
        map.put("subnets", SUBNETS_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("allocationStrategy", ALLOCATION_STRATEGY_FIELD);
        map.put("instanceTypes", INSTANCE_TYPES_FIELD);
        map.put("ec2KeyPair", EC2_KEY_PAIR_FIELD);
        map.put("instanceRole", INSTANCE_ROLE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("placementGroup", PLACEMENT_GROUP_FIELD);
        map.put("bidPercentage", BID_PERCENTAGE_FIELD);
        map.put("launchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("ec2Configuration", EC2_CONFIGURATION_FIELD);
        map.put("updateToLatestImageVersion", UPDATE_TO_LATEST_IMAGE_VERSION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("scalingPolicy", SCALING_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeResourceUpdate, T> g) {
        return obj -> g.apply((ComputeResourceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minvCpus;
        private Integer maxvCpus;
        private Integer desiredvCpus;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String allocationStrategy;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String ec2KeyPair;
        private String instanceRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String placementGroup;
        private Integer bidPercentage;
        private LaunchTemplateSpecification launchTemplate;
        private List<Ec2Configuration> ec2Configuration = DefaultSdkAutoConstructList.getInstance();
        private Boolean updateToLatestImageVersion;
        private String type;
        private String imageId;
        private ComputeScalingPolicy scalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResourceUpdate model) {
            this.minvCpus(model.minvCpus);
            this.maxvCpus(model.maxvCpus);
            this.desiredvCpus(model.desiredvCpus);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.allocationStrategy(model.allocationStrategy);
            this.instanceTypes(model.instanceTypes);
            this.ec2KeyPair(model.ec2KeyPair);
            this.instanceRole(model.instanceRole);
            this.tags(model.tags);
            this.placementGroup(model.placementGroup);
            this.bidPercentage(model.bidPercentage);
            this.launchTemplate(model.launchTemplate);
            this.ec2Configuration(model.ec2Configuration);
            this.updateToLatestImageVersion(model.updateToLatestImageVersion);
            this.type(model.type);
            this.imageId(model.imageId);
            this.scalingPolicy(model.scalingPolicy);
        }

        public final Integer getMinvCpus() {
            return this.minvCpus;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final Integer getMaxvCpus() {
            return this.maxvCpus;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final Integer getDesiredvCpus() {
            return this.desiredvCpus;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(CRUpdateAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final String getEc2KeyPair() {
            return this.ec2KeyPair;
        }

        public final void setEc2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
        }

        @Override
        public final Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final Integer getBidPercentage() {
            return this.bidPercentage;
        }

        public final void setBidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
        }

        @Override
        public final Builder bidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final List<Ec2Configuration.Builder> getEc2Configuration() {
            List<Ec2Configuration.Builder> result = Ec2ConfigurationListCopier.copyToBuilder(this.ec2Configuration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2Configuration(Collection<Ec2Configuration.BuilderImpl> ec2Configuration) {
            this.ec2Configuration = Ec2ConfigurationListCopier.copyFromBuilder(ec2Configuration);
        }

        @Override
        public final Builder ec2Configuration(Collection<Ec2Configuration> ec2Configuration) {
            this.ec2Configuration = Ec2ConfigurationListCopier.copy(ec2Configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Configuration(Ec2Configuration ... ec2Configuration) {
            this.ec2Configuration(Arrays.asList(ec2Configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Configuration(Consumer<Ec2Configuration.Builder> ... ec2Configuration) {
            this.ec2Configuration(Stream.of(ec2Configuration).map(c -> (Ec2Configuration)((Ec2Configuration.Builder)Ec2Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUpdateToLatestImageVersion() {
            return this.updateToLatestImageVersion;
        }

        public final void setUpdateToLatestImageVersion(Boolean updateToLatestImageVersion) {
            this.updateToLatestImageVersion = updateToLatestImageVersion;
        }

        @Override
        public final Builder updateToLatestImageVersion(Boolean updateToLatestImageVersion) {
            this.updateToLatestImageVersion = updateToLatestImageVersion;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CRType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final ComputeScalingPolicy.Builder getScalingPolicy() {
            return this.scalingPolicy != null ? this.scalingPolicy.toBuilder() : null;
        }

        public final void setScalingPolicy(ComputeScalingPolicy.BuilderImpl scalingPolicy) {
            this.scalingPolicy = scalingPolicy != null ? scalingPolicy.build() : null;
        }

        @Override
        public final Builder scalingPolicy(ComputeScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            return this;
        }

        public ComputeResourceUpdate build() {
            return new ComputeResourceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeResourceUpdate> {
        public Builder minvCpus(Integer var1);

        public Builder maxvCpus(Integer var1);

        public Builder desiredvCpus(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(CRUpdateAllocationStrategy var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder ec2KeyPair(String var1);

        public Builder instanceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder placementGroup(String var1);

        public Builder bidPercentage(Integer var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder ec2Configuration(Collection<Ec2Configuration> var1);

        public Builder ec2Configuration(Ec2Configuration ... var1);

        public Builder ec2Configuration(Consumer<Ec2Configuration.Builder> ... var1);

        public Builder updateToLatestImageVersion(Boolean var1);

        public Builder type(String var1);

        public Builder type(CRType var1);

        public Builder imageId(String var1);

        public Builder scalingPolicy(ComputeScalingPolicy var1);

        default public Builder scalingPolicy(Consumer<ComputeScalingPolicy.Builder> scalingPolicy) {
            return this.scalingPolicy((ComputeScalingPolicy)((ComputeScalingPolicy.Builder)ComputeScalingPolicy.builder().applyMutation(scalingPolicy)).build());
        }
    }
}

