/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.JobSummary;
import software.amazon.awssdk.services.batch.model.ListJobsRequest;
import software.amazon.awssdk.services.batch.model.ListJobsResponse;

public class ListJobsPublisher
implements SdkPublisher<ListJobsResponse> {
    private final BatchAsyncClient client;
    private final ListJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobsPublisher(BatchAsyncClient client, ListJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobsPublisher(BatchAsyncClient client, ListJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobSummary> jobSummaryList() {
        return this.flatMapIterable(response -> response.jobSummaryList());
    }

    private class ListJobsResponseFetcher
    implements AsyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobsResponse> nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsPublisher.this.client.listJobs(ListJobsPublisher.this.firstRequest);
            }
            return ListJobsPublisher.this.client.listJobs((ListJobsRequest)((Object)ListJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

