/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConsumableResourceRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, UpdateConsumableResourceRequest> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("consumableResource").getter(UpdateConsumableResourceRequest.getter(UpdateConsumableResourceRequest::consumableResource)).setter(UpdateConsumableResourceRequest.setter(Builder::consumableResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResource").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(UpdateConsumableResourceRequest.getter(UpdateConsumableResourceRequest::operation)).setter(UpdateConsumableResourceRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<Long> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("quantity").getter(UpdateConsumableResourceRequest.getter(UpdateConsumableResourceRequest::quantity)).setter(UpdateConsumableResourceRequest.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateConsumableResourceRequest.getter(UpdateConsumableResourceRequest::clientToken)).setter(UpdateConsumableResourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCE_FIELD, OPERATION_FIELD, QUANTITY_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConsumableResourceRequest.memberNameToFieldInitializer();
    private final String consumableResource;
    private final String operation;
    private final Long quantity;
    private final String clientToken;

    private UpdateConsumableResourceRequest(BuilderImpl builder) {
        super(builder);
        this.consumableResource = builder.consumableResource;
        this.operation = builder.operation;
        this.quantity = builder.quantity;
        this.clientToken = builder.clientToken;
    }

    public final String consumableResource() {
        return this.consumableResource;
    }

    public final String operation() {
        return this.operation;
    }

    public final Long quantity() {
        return this.quantity;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.consumableResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConsumableResourceRequest)) {
            return false;
        }
        UpdateConsumableResourceRequest other = (UpdateConsumableResourceRequest)((Object)obj);
        return Objects.equals(this.consumableResource(), other.consumableResource()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConsumableResourceRequest").add("ConsumableResource", (Object)this.consumableResource()).add("Operation", (Object)this.operation()).add("Quantity", (Object)this.quantity()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "consumableResource": {
                return Optional.ofNullable(clazz.cast(this.consumableResource()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consumableResource", CONSUMABLE_RESOURCE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("quantity", QUANTITY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConsumableResourceRequest, T> g) {
        return obj -> g.apply((UpdateConsumableResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String consumableResource;
        private String operation;
        private Long quantity;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConsumableResourceRequest model) {
            super(model);
            this.consumableResource(model.consumableResource);
            this.operation(model.operation);
            this.quantity(model.quantity);
            this.clientToken(model.clientToken);
        }

        public final String getConsumableResource() {
            return this.consumableResource;
        }

        public final void setConsumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
        }

        @Override
        public final Builder consumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final Long getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConsumableResourceRequest build() {
            return new UpdateConsumableResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConsumableResourceRequest> {
        public Builder consumableResource(String var1);

        public Builder operation(String var1);

        public Builder quantity(Long var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

