/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.FrontOfQueueDetail;
import software.amazon.awssdk.services.batch.model.QueueSnapshotUtilizationDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobQueueSnapshotResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, GetJobQueueSnapshotResponse> {
    private static final SdkField<FrontOfQueueDetail> FRONT_OF_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("frontOfQueue").getter(GetJobQueueSnapshotResponse.getter(GetJobQueueSnapshotResponse::frontOfQueue)).setter(GetJobQueueSnapshotResponse.setter(Builder::frontOfQueue)).constructor(FrontOfQueueDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frontOfQueue").build()}).build();
    private static final SdkField<QueueSnapshotUtilizationDetail> QUEUE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queueUtilization").getter(GetJobQueueSnapshotResponse.getter(GetJobQueueSnapshotResponse::queueUtilization)).setter(GetJobQueueSnapshotResponse.setter(Builder::queueUtilization)).constructor(QueueSnapshotUtilizationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueUtilization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRONT_OF_QUEUE_FIELD, QUEUE_UTILIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetJobQueueSnapshotResponse.memberNameToFieldInitializer();
    private final FrontOfQueueDetail frontOfQueue;
    private final QueueSnapshotUtilizationDetail queueUtilization;

    private GetJobQueueSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.frontOfQueue = builder.frontOfQueue;
        this.queueUtilization = builder.queueUtilization;
    }

    public final FrontOfQueueDetail frontOfQueue() {
        return this.frontOfQueue;
    }

    public final QueueSnapshotUtilizationDetail queueUtilization() {
        return this.queueUtilization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frontOfQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUtilization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobQueueSnapshotResponse)) {
            return false;
        }
        GetJobQueueSnapshotResponse other = (GetJobQueueSnapshotResponse)((Object)obj);
        return Objects.equals(this.frontOfQueue(), other.frontOfQueue()) && Objects.equals(this.queueUtilization(), other.queueUtilization());
    }

    public final String toString() {
        return ToString.builder((String)"GetJobQueueSnapshotResponse").add("FrontOfQueue", (Object)this.frontOfQueue()).add("QueueUtilization", (Object)this.queueUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frontOfQueue": {
                return Optional.ofNullable(clazz.cast(this.frontOfQueue()));
            }
            case "queueUtilization": {
                return Optional.ofNullable(clazz.cast(this.queueUtilization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frontOfQueue", FRONT_OF_QUEUE_FIELD);
        map.put("queueUtilization", QUEUE_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobQueueSnapshotResponse, T> g) {
        return obj -> g.apply((GetJobQueueSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private FrontOfQueueDetail frontOfQueue;
        private QueueSnapshotUtilizationDetail queueUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobQueueSnapshotResponse model) {
            super(model);
            this.frontOfQueue(model.frontOfQueue);
            this.queueUtilization(model.queueUtilization);
        }

        public final FrontOfQueueDetail.Builder getFrontOfQueue() {
            return this.frontOfQueue != null ? this.frontOfQueue.toBuilder() : null;
        }

        public final void setFrontOfQueue(FrontOfQueueDetail.BuilderImpl frontOfQueue) {
            this.frontOfQueue = frontOfQueue != null ? frontOfQueue.build() : null;
        }

        @Override
        public final Builder frontOfQueue(FrontOfQueueDetail frontOfQueue) {
            this.frontOfQueue = frontOfQueue;
            return this;
        }

        public final QueueSnapshotUtilizationDetail.Builder getQueueUtilization() {
            return this.queueUtilization != null ? this.queueUtilization.toBuilder() : null;
        }

        public final void setQueueUtilization(QueueSnapshotUtilizationDetail.BuilderImpl queueUtilization) {
            this.queueUtilization = queueUtilization != null ? queueUtilization.build() : null;
        }

        @Override
        public final Builder queueUtilization(QueueSnapshotUtilizationDetail queueUtilization) {
            this.queueUtilization = queueUtilization;
            return this;
        }

        @Override
        public GetJobQueueSnapshotResponse build() {
            return new GetJobQueueSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobQueueSnapshotResponse> {
        public Builder frontOfQueue(FrontOfQueueDetail var1);

        default public Builder frontOfQueue(Consumer<FrontOfQueueDetail.Builder> frontOfQueue) {
            return this.frontOfQueue((FrontOfQueueDetail)((FrontOfQueueDetail.Builder)FrontOfQueueDetail.builder().applyMutation(frontOfQueue)).build());
        }

        public Builder queueUtilization(QueueSnapshotUtilizationDetail var1);

        default public Builder queueUtilization(Consumer<QueueSnapshotUtilizationDetail.Builder> queueUtilization) {
            return this.queueUtilization((QueueSnapshotUtilizationDetail)((QueueSnapshotUtilizationDetail.Builder)QueueSnapshotUtilizationDetail.builder().applyMutation(queueUtilization)).build());
        }
    }
}

