/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EphemeralStorage;
import software.amazon.awssdk.services.batch.model.ListTaskContainerDetailsCopier;
import software.amazon.awssdk.services.batch.model.NetworkConfiguration;
import software.amazon.awssdk.services.batch.model.RuntimePlatform;
import software.amazon.awssdk.services.batch.model.TaskContainerDetails;
import software.amazon.awssdk.services.batch.model.Volume;
import software.amazon.awssdk.services.batch.model.VolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsTaskDetails> {
    private static final SdkField<List<TaskContainerDetails>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(EcsTaskDetails.getter(EcsTaskDetails::containers)).setter(EcsTaskDetails.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskContainerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerInstanceArn").getter(EcsTaskDetails.getter(EcsTaskDetails::containerInstanceArn)).setter(EcsTaskDetails.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(EcsTaskDetails.getter(EcsTaskDetails::taskArn)).setter(EcsTaskDetails.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeralStorage").getter(EcsTaskDetails.getter(EcsTaskDetails::ephemeralStorage)).setter(EcsTaskDetails.setter(Builder::ephemeralStorage)).constructor(EphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(EcsTaskDetails.getter(EcsTaskDetails::executionRoleArn)).setter(EcsTaskDetails.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(EcsTaskDetails.getter(EcsTaskDetails::platformVersion)).setter(EcsTaskDetails.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> IPC_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipcMode").getter(EcsTaskDetails.getter(EcsTaskDetails::ipcMode)).setter(EcsTaskDetails.setter(Builder::ipcMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipcMode").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRoleArn").getter(EcsTaskDetails.getter(EcsTaskDetails::taskRoleArn)).setter(EcsTaskDetails.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<String> PID_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pidMode").getter(EcsTaskDetails.getter(EcsTaskDetails::pidMode)).setter(EcsTaskDetails.setter(Builder::pidMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidMode").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(EcsTaskDetails.getter(EcsTaskDetails::networkConfiguration)).setter(EcsTaskDetails.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<RuntimePlatform> RUNTIME_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtimePlatform").getter(EcsTaskDetails.getter(EcsTaskDetails::runtimePlatform)).setter(EcsTaskDetails.setter(Builder::runtimePlatform)).constructor(RuntimePlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimePlatform").build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(EcsTaskDetails.getter(EcsTaskDetails::volumes)).setter(EcsTaskDetails.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableExecuteCommand").getter(EcsTaskDetails.getter(EcsTaskDetails::enableExecuteCommand)).setter(EcsTaskDetails.setter(Builder::enableExecuteCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD, CONTAINER_INSTANCE_ARN_FIELD, TASK_ARN_FIELD, EPHEMERAL_STORAGE_FIELD, EXECUTION_ROLE_ARN_FIELD, PLATFORM_VERSION_FIELD, IPC_MODE_FIELD, TASK_ROLE_ARN_FIELD, PID_MODE_FIELD, NETWORK_CONFIGURATION_FIELD, RUNTIME_PLATFORM_FIELD, VOLUMES_FIELD, ENABLE_EXECUTE_COMMAND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EcsTaskDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TaskContainerDetails> containers;
    private final String containerInstanceArn;
    private final String taskArn;
    private final EphemeralStorage ephemeralStorage;
    private final String executionRoleArn;
    private final String platformVersion;
    private final String ipcMode;
    private final String taskRoleArn;
    private final String pidMode;
    private final NetworkConfiguration networkConfiguration;
    private final RuntimePlatform runtimePlatform;
    private final List<Volume> volumes;
    private final Boolean enableExecuteCommand;

    private EcsTaskDetails(BuilderImpl builder) {
        this.containers = builder.containers;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.executionRoleArn = builder.executionRoleArn;
        this.platformVersion = builder.platformVersion;
        this.ipcMode = builder.ipcMode;
        this.taskRoleArn = builder.taskRoleArn;
        this.pidMode = builder.pidMode;
        this.networkConfiguration = builder.networkConfiguration;
        this.runtimePlatform = builder.runtimePlatform;
        this.volumes = builder.volumes;
        this.enableExecuteCommand = builder.enableExecuteCommand;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<TaskContainerDetails> containers() {
        return this.containers;
    }

    public final String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final EphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String ipcMode() {
        return this.ipcMode;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public final String pidMode() {
        return this.pidMode;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final RuntimePlatform runtimePlatform() {
        return this.runtimePlatform;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public final Boolean enableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipcMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pidMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimePlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExecuteCommand());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskDetails)) {
            return false;
        }
        EcsTaskDetails other = (EcsTaskDetails)obj;
        return this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.ipcMode(), other.ipcMode()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.pidMode(), other.pidMode()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.runtimePlatform(), other.runtimePlatform()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.enableExecuteCommand(), other.enableExecuteCommand());
    }

    public final String toString() {
        return ToString.builder((String)"EcsTaskDetails").add("Containers", this.hasContainers() ? this.containers() : null).add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("TaskArn", (Object)this.taskArn()).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("PlatformVersion", (Object)this.platformVersion()).add("IpcMode", (Object)this.ipcMode()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("PidMode", (Object)this.pidMode()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("RuntimePlatform", (Object)this.runtimePlatform()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("EnableExecuteCommand", (Object)this.enableExecuteCommand()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "ephemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "ipcMode": {
                return Optional.ofNullable(clazz.cast(this.ipcMode()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "pidMode": {
                return Optional.ofNullable(clazz.cast(this.pidMode()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "runtimePlatform": {
                return Optional.ofNullable(clazz.cast(this.runtimePlatform()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "enableExecuteCommand": {
                return Optional.ofNullable(clazz.cast(this.enableExecuteCommand()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containers", CONTAINERS_FIELD);
        map.put("containerInstanceArn", CONTAINER_INSTANCE_ARN_FIELD);
        map.put("taskArn", TASK_ARN_FIELD);
        map.put("ephemeralStorage", EPHEMERAL_STORAGE_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("platformVersion", PLATFORM_VERSION_FIELD);
        map.put("ipcMode", IPC_MODE_FIELD);
        map.put("taskRoleArn", TASK_ROLE_ARN_FIELD);
        map.put("pidMode", PID_MODE_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("runtimePlatform", RUNTIME_PLATFORM_FIELD);
        map.put("volumes", VOLUMES_FIELD);
        map.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsTaskDetails, T> g) {
        return obj -> g.apply((EcsTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TaskContainerDetails> containers = DefaultSdkAutoConstructList.getInstance();
        private String containerInstanceArn;
        private String taskArn;
        private EphemeralStorage ephemeralStorage;
        private String executionRoleArn;
        private String platformVersion;
        private String ipcMode;
        private String taskRoleArn;
        private String pidMode;
        private NetworkConfiguration networkConfiguration;
        private RuntimePlatform runtimePlatform;
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableExecuteCommand;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsTaskDetails model) {
            this.containers(model.containers);
            this.containerInstanceArn(model.containerInstanceArn);
            this.taskArn(model.taskArn);
            this.ephemeralStorage(model.ephemeralStorage);
            this.executionRoleArn(model.executionRoleArn);
            this.platformVersion(model.platformVersion);
            this.ipcMode(model.ipcMode);
            this.taskRoleArn(model.taskRoleArn);
            this.pidMode(model.pidMode);
            this.networkConfiguration(model.networkConfiguration);
            this.runtimePlatform(model.runtimePlatform);
            this.volumes(model.volumes);
            this.enableExecuteCommand(model.enableExecuteCommand);
        }

        public final List<TaskContainerDetails.Builder> getContainers() {
            List<TaskContainerDetails.Builder> result = ListTaskContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<TaskContainerDetails.BuilderImpl> containers) {
            this.containers = ListTaskContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<TaskContainerDetails> containers) {
            this.containers = ListTaskContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(TaskContainerDetails ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<TaskContainerDetails.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (TaskContainerDetails)((TaskContainerDetails.Builder)TaskContainerDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getIpcMode() {
            return this.ipcMode;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final String getPidMode() {
            return this.pidMode;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final RuntimePlatform.Builder getRuntimePlatform() {
            return this.runtimePlatform != null ? this.runtimePlatform.toBuilder() : null;
        }

        public final void setRuntimePlatform(RuntimePlatform.BuilderImpl runtimePlatform) {
            this.runtimePlatform = runtimePlatform != null ? runtimePlatform.build() : null;
        }

        @Override
        public final Builder runtimePlatform(RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public EcsTaskDetails build() {
            return new EcsTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsTaskDetails> {
        public Builder containers(Collection<TaskContainerDetails> var1);

        public Builder containers(TaskContainerDetails ... var1);

        public Builder containers(Consumer<TaskContainerDetails.Builder> ... var1);

        public Builder containerInstanceArn(String var1);

        public Builder taskArn(String var1);

        public Builder ephemeralStorage(EphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EphemeralStorage)((EphemeralStorage.Builder)EphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder platformVersion(String var1);

        public Builder ipcMode(String var1);

        public Builder taskRoleArn(String var1);

        public Builder pidMode(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder runtimePlatform(RuntimePlatform var1);

        default public Builder runtimePlatform(Consumer<RuntimePlatform.Builder> runtimePlatform) {
            return this.runtimePlatform((RuntimePlatform)((RuntimePlatform.Builder)RuntimePlatform.builder().applyMutation(runtimePlatform)).build());
        }

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder enableExecuteCommand(Boolean var1);
    }
}

