/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FirelensConfigurationType {
    FLUENTD("fluentd"),
    FLUENTBIT("fluentbit"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FirelensConfigurationType> VALUE_MAP;
    private final String value;

    private FirelensConfigurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FirelensConfigurationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FirelensConfigurationType> knownValues() {
        EnumSet<FirelensConfigurationType> knownValues = EnumSet.allOf(FirelensConfigurationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FirelensConfigurationType.class, FirelensConfigurationType::toString);
    }
}

