/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConsumableResourcesRequest extends BatchRequest implements
        ToCopyableBuilder<ListConsumableResourcesRequest.Builder, ListConsumableResourcesRequest> {
    private static final SdkField<List<KeyValuesPair>> FILTERS_FIELD = SdkField
            .<List<KeyValuesPair>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListConsumableResourcesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuesPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuesPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListConsumableResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConsumableResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<KeyValuesPair> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListConsumableResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to apply to the consumable resource list query. If used, only those consumable resources that match
     * the filter are listed. Filter names and values can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * name: <code>CONSUMABLE_RESOURCE_NAME </code>
     * </p>
     * <p>
     * values: case-insensitive matches for the consumable resource name. If a filter value ends with an asterisk (*),
     * it matches any consumable resource name that begins with the string before the '*'.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters to apply to the consumable resource list query. If used, only those consumable resources that
     *         match the filter are listed. Filter names and values can be:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         name: <code>CONSUMABLE_RESOURCE_NAME </code>
     *         </p>
     *         <p>
     *         values: case-insensitive matches for the consumable resource name. If a filter value ends with an
     *         asterisk (*), it matches any consumable resource name that begins with the string before the '*'.
     *         </p>
     *         </li>
     */
    public final List<KeyValuesPair> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListConsumableResources</code> in paginated output. When this
     * parameter is used, <code>ListConsumableResources</code> only returns <code>maxResults</code> results in a single
     * page and a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>ListConsumableResources</code> request with the returned <code>nextToken</code> value. This
     * value can be between 1 and 100. If this parameter isn't used, then <code>ListConsumableResources</code> returns
     * up to 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListConsumableResources</code> in paginated output. When
     *         this parameter is used, <code>ListConsumableResources</code> only returns <code>maxResults</code> results
     *         in a single page and a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>ListConsumableResources</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
     *         <code>ListConsumableResources</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListConsumableResources</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for other
     * programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListConsumableResources</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not
     *         for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConsumableResourcesRequest)) {
            return false;
        }
        ListConsumableResourcesRequest other = (ListConsumableResourcesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConsumableResourcesRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConsumableResourcesRequest, T> g) {
        return obj -> g.apply((ListConsumableResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConsumableResourcesRequest> {
        /**
         * <p>
         * The filters to apply to the consumable resource list query. If used, only those consumable resources that
         * match the filter are listed. Filter names and values can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * name: <code>CONSUMABLE_RESOURCE_NAME </code>
         * </p>
         * <p>
         * values: case-insensitive matches for the consumable resource name. If a filter value ends with an asterisk
         * (*), it matches any consumable resource name that begins with the string before the '*'.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters to apply to the consumable resource list query. If used, only those consumable resources
         *        that match the filter are listed. Filter names and values can be:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        name: <code>CONSUMABLE_RESOURCE_NAME </code>
         *        </p>
         *        <p>
         *        values: case-insensitive matches for the consumable resource name. If a filter value ends with an
         *        asterisk (*), it matches any consumable resource name that begins with the string before the '*'.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<KeyValuesPair> filters);

        /**
         * <p>
         * The filters to apply to the consumable resource list query. If used, only those consumable resources that
         * match the filter are listed. Filter names and values can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * name: <code>CONSUMABLE_RESOURCE_NAME </code>
         * </p>
         * <p>
         * values: case-insensitive matches for the consumable resource name. If a filter value ends with an asterisk
         * (*), it matches any consumable resource name that begins with the string before the '*'.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters to apply to the consumable resource list query. If used, only those consumable resources
         *        that match the filter are listed. Filter names and values can be:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        name: <code>CONSUMABLE_RESOURCE_NAME </code>
         *        </p>
         *        <p>
         *        values: case-insensitive matches for the consumable resource name. If a filter value ends with an
         *        asterisk (*), it matches any consumable resource name that begins with the string before the '*'.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(KeyValuesPair... filters);

        /**
         * <p>
         * The filters to apply to the consumable resource list query. If used, only those consumable resources that
         * match the filter are listed. Filter names and values can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * name: <code>CONSUMABLE_RESOURCE_NAME </code>
         * </p>
         * <p>
         * values: case-insensitive matches for the consumable resource name. If a filter value ends with an asterisk
         * (*), it matches any consumable resource name that begins with the string before the '*'.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.KeyValuesPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<KeyValuesPair>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<KeyValuesPair>)
         */
        Builder filters(Consumer<KeyValuesPair.Builder>... filters);

        /**
         * <p>
         * The maximum number of results returned by <code>ListConsumableResources</code> in paginated output. When this
         * parameter is used, <code>ListConsumableResources</code> only returns <code>maxResults</code> results in a
         * single page and a <code>nextToken</code> response element. The remaining results of the initial request can
         * be seen by sending another <code>ListConsumableResources</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         * <code>ListConsumableResources</code> returns up to 100 results and a <code>nextToken</code> value if
         * applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListConsumableResources</code> in paginated output.
         *        When this parameter is used, <code>ListConsumableResources</code> only returns <code>maxResults</code>
         *        results in a single page and a <code>nextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>ListConsumableResources</code> request with the
         *        returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't
         *        used, then <code>ListConsumableResources</code> returns up to 100 results and a <code>nextToken</code>
         *        value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListConsumableResources</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * This value is <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for
         * other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>ListConsumableResources</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more
         *        results to return.</p> <note>
         *        <p>
         *        Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not
         *        for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private List<KeyValuesPair> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConsumableResourcesRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<KeyValuesPair.Builder> getFilters() {
            List<KeyValuesPair.Builder> result = ListConsumableResourcesFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<KeyValuesPair.BuilderImpl> filters) {
            this.filters = ListConsumableResourcesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<KeyValuesPair> filters) {
            this.filters = ListConsumableResourcesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(KeyValuesPair... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<KeyValuesPair.Builder>... filters) {
            filters(Stream.of(filters).map(c -> KeyValuesPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConsumableResourcesRequest build() {
            return new ListConsumableResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
