/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the latest attempt of a service job. A Service job can transition from <code>SCHEDULED</code> back
 * to <code>RUNNABLE</code> state when they encounter capacity constraints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LatestServiceJobAttempt implements SdkPojo, Serializable,
        ToCopyableBuilder<LatestServiceJobAttempt.Builder, LatestServiceJobAttempt> {
    private static final SdkField<ServiceResourceId> SERVICE_RESOURCE_ID_FIELD = SdkField
            .<ServiceResourceId> builder(MarshallingType.SDK_POJO).memberName("serviceResourceId")
            .getter(getter(LatestServiceJobAttempt::serviceResourceId)).setter(setter(Builder::serviceResourceId))
            .constructor(ServiceResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceResourceId serviceResourceId;

    private LatestServiceJobAttempt(BuilderImpl builder) {
        this.serviceResourceId = builder.serviceResourceId;
    }

    /**
     * <p>
     * The service resource identifier associated with the service job attempt.
     * </p>
     * 
     * @return The service resource identifier associated with the service job attempt.
     */
    public final ServiceResourceId serviceResourceId() {
        return serviceResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceResourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestServiceJobAttempt)) {
            return false;
        }
        LatestServiceJobAttempt other = (LatestServiceJobAttempt) obj;
        return Objects.equals(serviceResourceId(), other.serviceResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LatestServiceJobAttempt").add("ServiceResourceId", serviceResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceResourceId":
            return Optional.ofNullable(clazz.cast(serviceResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceResourceId", SERVICE_RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LatestServiceJobAttempt, T> g) {
        return obj -> g.apply((LatestServiceJobAttempt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LatestServiceJobAttempt> {
        /**
         * <p>
         * The service resource identifier associated with the service job attempt.
         * </p>
         * 
         * @param serviceResourceId
         *        The service resource identifier associated with the service job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceResourceId(ServiceResourceId serviceResourceId);

        /**
         * <p>
         * The service resource identifier associated with the service job attempt.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceResourceId.Builder} avoiding the
         * need to create one manually via {@link ServiceResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceResourceId(ServiceResourceId)}.
         * 
         * @param serviceResourceId
         *        a consumer that will call methods on {@link ServiceResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceResourceId(ServiceResourceId)
         */
        default Builder serviceResourceId(Consumer<ServiceResourceId.Builder> serviceResourceId) {
            return serviceResourceId(ServiceResourceId.builder().applyMutation(serviceResourceId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceResourceId serviceResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(LatestServiceJobAttempt model) {
            serviceResourceId(model.serviceResourceId);
        }

        public final ServiceResourceId.Builder getServiceResourceId() {
            return serviceResourceId != null ? serviceResourceId.toBuilder() : null;
        }

        public final void setServiceResourceId(ServiceResourceId.BuilderImpl serviceResourceId) {
            this.serviceResourceId = serviceResourceId != null ? serviceResourceId.build() : null;
        }

        @Override
        public final Builder serviceResourceId(ServiceResourceId serviceResourceId) {
            this.serviceResourceId = serviceResourceId;
            return this;
        }

        @Override
        public LatestServiceJobAttempt build() {
            return new LatestServiceJobAttempt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
