/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains overrides for the Amazon ECS task definition of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsPropertiesOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<EcsPropertiesOverride.Builder, EcsPropertiesOverride> {
    private static final SdkField<List<TaskPropertiesOverride>> TASK_PROPERTIES_FIELD = SdkField
            .<List<TaskPropertiesOverride>> builder(MarshallingType.LIST)
            .memberName("taskProperties")
            .getter(getter(EcsPropertiesOverride::taskProperties))
            .setter(setter(Builder::taskProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskPropertiesOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskPropertiesOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TaskPropertiesOverride> taskProperties;

    private EcsPropertiesOverride(BuilderImpl builder) {
        this.taskProperties = builder.taskProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskProperties() {
        return taskProperties != null && !(taskProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The overrides for the Amazon ECS task definition of a job.
     * </p>
     * <note>
     * <p>
     * This object is currently limited to one element.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskProperties} method.
     * </p>
     * 
     * @return The overrides for the Amazon ECS task definition of a job.</p> <note>
     *         <p>
     *         This object is currently limited to one element.
     *         </p>
     */
    public final List<TaskPropertiesOverride> taskProperties() {
        return taskProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskProperties() ? taskProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsPropertiesOverride)) {
            return false;
        }
        EcsPropertiesOverride other = (EcsPropertiesOverride) obj;
        return hasTaskProperties() == other.hasTaskProperties() && Objects.equals(taskProperties(), other.taskProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsPropertiesOverride").add("TaskProperties", hasTaskProperties() ? taskProperties() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskProperties":
            return Optional.ofNullable(clazz.cast(taskProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskProperties", TASK_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsPropertiesOverride, T> g) {
        return obj -> g.apply((EcsPropertiesOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsPropertiesOverride> {
        /**
         * <p>
         * The overrides for the Amazon ECS task definition of a job.
         * </p>
         * <note>
         * <p>
         * This object is currently limited to one element.
         * </p>
         * </note>
         * 
         * @param taskProperties
         *        The overrides for the Amazon ECS task definition of a job.</p> <note>
         *        <p>
         *        This object is currently limited to one element.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(Collection<TaskPropertiesOverride> taskProperties);

        /**
         * <p>
         * The overrides for the Amazon ECS task definition of a job.
         * </p>
         * <note>
         * <p>
         * This object is currently limited to one element.
         * </p>
         * </note>
         * 
         * @param taskProperties
         *        The overrides for the Amazon ECS task definition of a job.</p> <note>
         *        <p>
         *        This object is currently limited to one element.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(TaskPropertiesOverride... taskProperties);

        /**
         * <p>
         * The overrides for the Amazon ECS task definition of a job.
         * </p>
         * <note>
         * <p>
         * This object is currently limited to one element.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.TaskPropertiesOverride.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.batch.model.TaskPropertiesOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.TaskPropertiesOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #taskProperties(List<TaskPropertiesOverride>)}.
         * 
         * @param taskProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.TaskPropertiesOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskProperties(java.util.Collection<TaskPropertiesOverride>)
         */
        Builder taskProperties(Consumer<TaskPropertiesOverride.Builder>... taskProperties);
    }

    static final class BuilderImpl implements Builder {
        private List<TaskPropertiesOverride> taskProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsPropertiesOverride model) {
            taskProperties(model.taskProperties);
        }

        public final List<TaskPropertiesOverride.Builder> getTaskProperties() {
            List<TaskPropertiesOverride.Builder> result = ListTaskPropertiesOverrideCopier.copyToBuilder(this.taskProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskProperties(Collection<TaskPropertiesOverride.BuilderImpl> taskProperties) {
            this.taskProperties = ListTaskPropertiesOverrideCopier.copyFromBuilder(taskProperties);
        }

        @Override
        public final Builder taskProperties(Collection<TaskPropertiesOverride> taskProperties) {
            this.taskProperties = ListTaskPropertiesOverrideCopier.copy(taskProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(TaskPropertiesOverride... taskProperties) {
            taskProperties(Arrays.asList(taskProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(Consumer<TaskPropertiesOverride.Builder>... taskProperties) {
            taskProperties(Stream.of(taskProperties).map(c -> TaskPropertiesOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EcsPropertiesOverride build() {
            return new EcsPropertiesOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
