/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConsumableResourceRequest extends BatchRequest implements
        ToCopyableBuilder<DescribeConsumableResourceRequest.Builder, DescribeConsumableResourceRequest> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResource").getter(getter(DescribeConsumableResourceRequest::consumableResource))
            .setter(setter(Builder::consumableResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String consumableResource;

    private DescribeConsumableResourceRequest(BuilderImpl builder) {
        super(builder);
        this.consumableResource = builder.consumableResource;
    }

    /**
     * <p>
     * The name or ARN of the consumable resource whose description will be returned.
     * </p>
     * 
     * @return The name or ARN of the consumable resource whose description will be returned.
     */
    public final String consumableResource() {
        return consumableResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumableResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConsumableResourceRequest)) {
            return false;
        }
        DescribeConsumableResourceRequest other = (DescribeConsumableResourceRequest) obj;
        return Objects.equals(consumableResource(), other.consumableResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConsumableResourceRequest").add("ConsumableResource", consumableResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResource":
            return Optional.ofNullable(clazz.cast(consumableResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResource", CONSUMABLE_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConsumableResourceRequest, T> g) {
        return obj -> g.apply((DescribeConsumableResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConsumableResourceRequest> {
        /**
         * <p>
         * The name or ARN of the consumable resource whose description will be returned.
         * </p>
         * 
         * @param consumableResource
         *        The name or ARN of the consumable resource whose description will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResource(String consumableResource);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String consumableResource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConsumableResourceRequest model) {
            super(model);
            consumableResource(model.consumableResource);
        }

        public final String getConsumableResource() {
            return consumableResource;
        }

        public final void setConsumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
        }

        @Override
        public final Builder consumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConsumableResourceRequest build() {
            return new DescribeConsumableResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
