/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the capacity limit for a service environment. This structure specifies the maximum amount of resources that
 * can be used by service jobs in the environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityLimit implements SdkPojo, Serializable, ToCopyableBuilder<CapacityLimit.Builder, CapacityLimit> {
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCapacity").getter(getter(CapacityLimit::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()).build();

    private static final SdkField<String> CAPACITY_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityUnit").getter(getter(CapacityLimit::capacityUnit)).setter(setter(Builder::capacityUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CAPACITY_FIELD,
            CAPACITY_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxCapacity;

    private final String capacityUnit;

    private CapacityLimit(BuilderImpl builder) {
        this.maxCapacity = builder.maxCapacity;
        this.capacityUnit = builder.capacityUnit;
    }

    /**
     * <p>
     * The maximum capacity available for the service environment. This value represents the maximum amount of resources
     * that can be allocated to service jobs.
     * </p>
     * <p>
     * For example, <code>maxCapacity=50</code>, <code>capacityUnit=NUM_INSTANCES</code>. This indicates that the
     * maximum number of instances that can be run on this service environment is 50. You could then run 5 SageMaker
     * Training jobs that each use 10 instances. However, if you submit another job that requires 10 instances, it will
     * wait in the queue.
     * </p>
     * 
     * @return The maximum capacity available for the service environment. This value represents the maximum amount of
     *         resources that can be allocated to service jobs.</p>
     *         <p>
     *         For example, <code>maxCapacity=50</code>, <code>capacityUnit=NUM_INSTANCES</code>. This indicates that
     *         the maximum number of instances that can be run on this service environment is 50. You could then run 5
     *         SageMaker Training jobs that each use 10 instances. However, if you submit another job that requires 10
     *         instances, it will wait in the queue.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The unit of measure for the capacity limit. This defines how the maxCapacity value should be interpreted. For
     * <code>SAGEMAKER_TRAINING</code> jobs, use <code>NUM_INSTANCES</code>.
     * </p>
     * 
     * @return The unit of measure for the capacity limit. This defines how the maxCapacity value should be interpreted.
     *         For <code>SAGEMAKER_TRAINING</code> jobs, use <code>NUM_INSTANCES</code>.
     */
    public final String capacityUnit() {
        return capacityUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityLimit)) {
            return false;
        }
        CapacityLimit other = (CapacityLimit) obj;
        return Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(capacityUnit(), other.capacityUnit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityLimit").add("MaxCapacity", maxCapacity()).add("CapacityUnit", capacityUnit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "capacityUnit":
            return Optional.ofNullable(clazz.cast(capacityUnit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxCapacity", MAX_CAPACITY_FIELD);
        map.put("capacityUnit", CAPACITY_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityLimit, T> g) {
        return obj -> g.apply((CapacityLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityLimit> {
        /**
         * <p>
         * The maximum capacity available for the service environment. This value represents the maximum amount of
         * resources that can be allocated to service jobs.
         * </p>
         * <p>
         * For example, <code>maxCapacity=50</code>, <code>capacityUnit=NUM_INSTANCES</code>. This indicates that the
         * maximum number of instances that can be run on this service environment is 50. You could then run 5 SageMaker
         * Training jobs that each use 10 instances. However, if you submit another job that requires 10 instances, it
         * will wait in the queue.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity available for the service environment. This value represents the maximum amount
         *        of resources that can be allocated to service jobs.</p>
         *        <p>
         *        For example, <code>maxCapacity=50</code>, <code>capacityUnit=NUM_INSTANCES</code>. This indicates that
         *        the maximum number of instances that can be run on this service environment is 50. You could then run
         *        5 SageMaker Training jobs that each use 10 instances. However, if you submit another job that requires
         *        10 instances, it will wait in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The unit of measure for the capacity limit. This defines how the maxCapacity value should be interpreted. For
         * <code>SAGEMAKER_TRAINING</code> jobs, use <code>NUM_INSTANCES</code>.
         * </p>
         * 
         * @param capacityUnit
         *        The unit of measure for the capacity limit. This defines how the maxCapacity value should be
         *        interpreted. For <code>SAGEMAKER_TRAINING</code> jobs, use <code>NUM_INSTANCES</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnit(String capacityUnit);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxCapacity;

        private String capacityUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityLimit model) {
            maxCapacity(model.maxCapacity);
            capacityUnit(model.capacityUnit);
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getCapacityUnit() {
            return capacityUnit;
        }

        public final void setCapacityUnit(String capacityUnit) {
            this.capacityUnit = capacityUnit;
        }

        @Override
        public final Builder capacityUnit(String capacityUnit) {
            this.capacityUnit = capacityUnit;
            return this;
        }

        @Override
        public CapacityLimit build() {
            return new CapacityLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
