/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentDetail;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceEnvironmentsResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeServiceEnvironmentsResponse> {
    private static final SdkField<List<ServiceEnvironmentDetail>> SERVICE_ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceEnvironments").getter(DescribeServiceEnvironmentsResponse.getter(DescribeServiceEnvironmentsResponse::serviceEnvironments)).setter(DescribeServiceEnvironmentsResponse.setter(Builder::serviceEnvironments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceEnvironmentDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeServiceEnvironmentsResponse.getter(DescribeServiceEnvironmentsResponse::nextToken)).setter(DescribeServiceEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ENVIRONMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceEnvironmentsResponse.memberNameToFieldInitializer();
    private final List<ServiceEnvironmentDetail> serviceEnvironments;
    private final String nextToken;

    private DescribeServiceEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceEnvironments = builder.serviceEnvironments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceEnvironments() {
        return this.serviceEnvironments != null && !(this.serviceEnvironments instanceof SdkAutoConstructList);
    }

    public final List<ServiceEnvironmentDetail> serviceEnvironments() {
        return this.serviceEnvironments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceEnvironments() ? this.serviceEnvironments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceEnvironmentsResponse)) {
            return false;
        }
        DescribeServiceEnvironmentsResponse other = (DescribeServiceEnvironmentsResponse)((Object)obj);
        return this.hasServiceEnvironments() == other.hasServiceEnvironments() && Objects.equals(this.serviceEnvironments(), other.serviceEnvironments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceEnvironmentsResponse").add("ServiceEnvironments", this.hasServiceEnvironments() ? this.serviceEnvironments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceEnvironments": {
                return Optional.ofNullable(clazz.cast(this.serviceEnvironments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceEnvironments", SERVICE_ENVIRONMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeServiceEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<ServiceEnvironmentDetail> serviceEnvironments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceEnvironmentsResponse model) {
            super(model);
            this.serviceEnvironments(model.serviceEnvironments);
            this.nextToken(model.nextToken);
        }

        public final List<ServiceEnvironmentDetail.Builder> getServiceEnvironments() {
            List<ServiceEnvironmentDetail.Builder> result = ServiceEnvironmentDetailListCopier.copyToBuilder(this.serviceEnvironments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceEnvironments(Collection<ServiceEnvironmentDetail.BuilderImpl> serviceEnvironments) {
            this.serviceEnvironments = ServiceEnvironmentDetailListCopier.copyFromBuilder(serviceEnvironments);
        }

        @Override
        public final Builder serviceEnvironments(Collection<ServiceEnvironmentDetail> serviceEnvironments) {
            this.serviceEnvironments = ServiceEnvironmentDetailListCopier.copy(serviceEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceEnvironments(ServiceEnvironmentDetail ... serviceEnvironments) {
            this.serviceEnvironments(Arrays.asList(serviceEnvironments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceEnvironments(Consumer<ServiceEnvironmentDetail.Builder> ... serviceEnvironments) {
            this.serviceEnvironments(Stream.of(serviceEnvironments).map(c -> (ServiceEnvironmentDetail)((ServiceEnvironmentDetail.Builder)ServiceEnvironmentDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeServiceEnvironmentsResponse build() {
            return new DescribeServiceEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceEnvironmentsResponse> {
        public Builder serviceEnvironments(Collection<ServiceEnvironmentDetail> var1);

        public Builder serviceEnvironments(ServiceEnvironmentDetail ... var1);

        public Builder serviceEnvironments(Consumer<ServiceEnvironmentDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

