/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.ServiceJobRetryStrategy;
import software.amazon.awssdk.services.batch.model.ServiceJobTimeout;
import software.amazon.awssdk.services.batch.model.ServiceJobType;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitServiceJobRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, SubmitServiceJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::jobName)).setter(SubmitServiceJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobQueue").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::jobQueue)).setter(SubmitServiceJobRequest.setter(Builder::jobQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()}).build();
    private static final SdkField<ServiceJobRetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStrategy").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::retryStrategy)).setter(SubmitServiceJobRequest.setter(Builder::retryStrategy)).constructor(ServiceJobRetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()}).build();
    private static final SdkField<Integer> SCHEDULING_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schedulingPriority").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::schedulingPriority)).setter(SubmitServiceJobRequest.setter(Builder::schedulingPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriority").build()}).build();
    private static final SdkField<String> SERVICE_REQUEST_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRequestPayload").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::serviceRequestPayload)).setter(SubmitServiceJobRequest.setter(Builder::serviceRequestPayload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRequestPayload").build()}).build();
    private static final SdkField<String> SERVICE_JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceJobType").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::serviceJobTypeAsString)).setter(SubmitServiceJobRequest.setter(Builder::serviceJobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceJobType").build()}).build();
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::shareIdentifier)).setter(SubmitServiceJobRequest.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<ServiceJobTimeout> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::timeoutConfig)).setter(SubmitServiceJobRequest.setter(Builder::timeoutConfig)).constructor(ServiceJobTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::tags)).setter(SubmitServiceJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(SubmitServiceJobRequest.getter(SubmitServiceJobRequest::clientToken)).setter(SubmitServiceJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_QUEUE_FIELD, RETRY_STRATEGY_FIELD, SCHEDULING_PRIORITY_FIELD, SERVICE_REQUEST_PAYLOAD_FIELD, SERVICE_JOB_TYPE_FIELD, SHARE_IDENTIFIER_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubmitServiceJobRequest.memberNameToFieldInitializer();
    private final String jobName;
    private final String jobQueue;
    private final ServiceJobRetryStrategy retryStrategy;
    private final Integer schedulingPriority;
    private final String serviceRequestPayload;
    private final String serviceJobType;
    private final String shareIdentifier;
    private final ServiceJobTimeout timeoutConfig;
    private final Map<String, String> tags;
    private final String clientToken;

    private SubmitServiceJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.retryStrategy = builder.retryStrategy;
        this.schedulingPriority = builder.schedulingPriority;
        this.serviceRequestPayload = builder.serviceRequestPayload;
        this.serviceJobType = builder.serviceJobType;
        this.shareIdentifier = builder.shareIdentifier;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobQueue() {
        return this.jobQueue;
    }

    public final ServiceJobRetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final Integer schedulingPriority() {
        return this.schedulingPriority;
    }

    public final String serviceRequestPayload() {
        return this.serviceRequestPayload;
    }

    public final ServiceJobType serviceJobType() {
        return ServiceJobType.fromValue(this.serviceJobType);
    }

    public final String serviceJobTypeAsString() {
        return this.serviceJobType;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final ServiceJobTimeout timeoutConfig() {
        return this.timeoutConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRequestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitServiceJobRequest)) {
            return false;
        }
        SubmitServiceJobRequest other = (SubmitServiceJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.schedulingPriority(), other.schedulingPriority()) && Objects.equals(this.serviceRequestPayload(), other.serviceRequestPayload()) && Objects.equals(this.serviceJobTypeAsString(), other.serviceJobTypeAsString()) && Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"SubmitServiceJobRequest").add("JobName", (Object)this.jobName()).add("JobQueue", (Object)this.jobQueue()).add("RetryStrategy", (Object)this.retryStrategy()).add("SchedulingPriority", (Object)this.schedulingPriority()).add("ServiceRequestPayload", (Object)this.serviceRequestPayload()).add("ServiceJobType", (Object)this.serviceJobTypeAsString()).add("ShareIdentifier", (Object)this.shareIdentifier()).add("TimeoutConfig", (Object)this.timeoutConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobQueue": {
                return Optional.ofNullable(clazz.cast(this.jobQueue()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "schedulingPriority": {
                return Optional.ofNullable(clazz.cast(this.schedulingPriority()));
            }
            case "serviceRequestPayload": {
                return Optional.ofNullable(clazz.cast(this.serviceRequestPayload()));
            }
            case "serviceJobType": {
                return Optional.ofNullable(clazz.cast(this.serviceJobTypeAsString()));
            }
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobQueue", JOB_QUEUE_FIELD);
        map.put("retryStrategy", RETRY_STRATEGY_FIELD);
        map.put("schedulingPriority", SCHEDULING_PRIORITY_FIELD);
        map.put("serviceRequestPayload", SERVICE_REQUEST_PAYLOAD_FIELD);
        map.put("serviceJobType", SERVICE_JOB_TYPE_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitServiceJobRequest, T> g) {
        return obj -> g.apply((SubmitServiceJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobQueue;
        private ServiceJobRetryStrategy retryStrategy;
        private Integer schedulingPriority;
        private String serviceRequestPayload;
        private String serviceJobType;
        private String shareIdentifier;
        private ServiceJobTimeout timeoutConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitServiceJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobQueue(model.jobQueue);
            this.retryStrategy(model.retryStrategy);
            this.schedulingPriority(model.schedulingPriority);
            this.serviceRequestPayload(model.serviceRequestPayload);
            this.serviceJobType(model.serviceJobType);
            this.shareIdentifier(model.shareIdentifier);
            this.timeoutConfig(model.timeoutConfig);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final ServiceJobRetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(ServiceJobRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(ServiceJobRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Integer getSchedulingPriority() {
            return this.schedulingPriority;
        }

        public final void setSchedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
        }

        @Override
        public final Builder schedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        public final String getServiceRequestPayload() {
            return this.serviceRequestPayload;
        }

        public final void setServiceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
        }

        @Override
        public final Builder serviceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
            return this;
        }

        public final String getServiceJobType() {
            return this.serviceJobType;
        }

        public final void setServiceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
        }

        @Override
        public final Builder serviceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
            return this;
        }

        @Override
        public final Builder serviceJobType(ServiceJobType serviceJobType) {
            this.serviceJobType(serviceJobType == null ? null : serviceJobType.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final ServiceJobTimeout.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(ServiceJobTimeout.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(ServiceJobTimeout timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitServiceJobRequest build() {
            return new SubmitServiceJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitServiceJobRequest> {
        public Builder jobName(String var1);

        public Builder jobQueue(String var1);

        public Builder retryStrategy(ServiceJobRetryStrategy var1);

        default public Builder retryStrategy(Consumer<ServiceJobRetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((ServiceJobRetryStrategy)((ServiceJobRetryStrategy.Builder)ServiceJobRetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder schedulingPriority(Integer var1);

        public Builder serviceRequestPayload(String var1);

        public Builder serviceJobType(String var1);

        public Builder serviceJobType(ServiceJobType var1);

        public Builder shareIdentifier(String var1);

        public Builder timeoutConfig(ServiceJobTimeout var1);

        default public Builder timeoutConfig(Consumer<ServiceJobTimeout.Builder> timeoutConfig) {
            return this.timeoutConfig((ServiceJobTimeout)((ServiceJobTimeout.Builder)ServiceJobTimeout.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

