/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.CEStatus;
import software.amazon.awssdk.services.batch.model.CEType;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.services.batch.model.EksConfiguration;
import software.amazon.awssdk.services.batch.model.OrchestrationType;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.services.batch.model.UpdatePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeEnvironmentDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeEnvironmentDetail> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironmentName").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::computeEnvironmentName)).setter(ComputeEnvironmentDetail.setter(Builder::computeEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentName").build()}).build();
    private static final SdkField<String> COMPUTE_ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironmentArn").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::computeEnvironmentArn)).setter(ComputeEnvironmentDetail.setter(Builder::computeEnvironmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentArn").build()}).build();
    private static final SdkField<Integer> UNMANAGEDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("unmanagedvCpus").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::unmanagedvCpus)).setter(ComputeEnvironmentDetail.setter(Builder::unmanagedvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmanagedvCpus").build()}).build();
    private static final SdkField<String> ECS_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecsClusterArn").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::ecsClusterArn)).setter(ComputeEnvironmentDetail.setter(Builder::ecsClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsClusterArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::tags)).setter(ComputeEnvironmentDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::typeAsString)).setter(ComputeEnvironmentDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::stateAsString)).setter(ComputeEnvironmentDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::statusAsString)).setter(ComputeEnvironmentDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::statusReason)).setter(ComputeEnvironmentDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<ComputeResource> COMPUTE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeResources").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::computeResources)).setter(ComputeEnvironmentDetail.setter(Builder::computeResources)).constructor(ComputeResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeResources").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::serviceRole)).setter(ComputeEnvironmentDetail.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<UpdatePolicy> UPDATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updatePolicy").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::updatePolicy)).setter(ComputeEnvironmentDetail.setter(Builder::updatePolicy)).constructor(UpdatePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatePolicy").build()}).build();
    private static final SdkField<EksConfiguration> EKS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksConfiguration").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::eksConfiguration)).setter(ComputeEnvironmentDetail.setter(Builder::eksConfiguration)).constructor(EksConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksConfiguration").build()}).build();
    private static final SdkField<String> CONTAINER_ORCHESTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerOrchestrationType").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::containerOrchestrationTypeAsString)).setter(ComputeEnvironmentDetail.setter(Builder::containerOrchestrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOrchestrationType").build()}).build();
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uuid").getter(ComputeEnvironmentDetail.getter(ComputeEnvironmentDetail::uuid)).setter(ComputeEnvironmentDetail.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENT_NAME_FIELD, COMPUTE_ENVIRONMENT_ARN_FIELD, UNMANAGEDV_CPUS_FIELD, ECS_CLUSTER_ARN_FIELD, TAGS_FIELD, TYPE_FIELD, STATE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, COMPUTE_RESOURCES_FIELD, SERVICE_ROLE_FIELD, UPDATE_POLICY_FIELD, EKS_CONFIGURATION_FIELD, CONTAINER_ORCHESTRATION_TYPE_FIELD, UUID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String computeEnvironmentName;
    private final String computeEnvironmentArn;
    private final Integer unmanagedvCpus;
    private final String ecsClusterArn;
    private final Map<String, String> tags;
    private final String type;
    private final String state;
    private final String status;
    private final String statusReason;
    private final ComputeResource computeResources;
    private final String serviceRole;
    private final UpdatePolicy updatePolicy;
    private final EksConfiguration eksConfiguration;
    private final String containerOrchestrationType;
    private final String uuid;

    private ComputeEnvironmentDetail(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
        this.unmanagedvCpus = builder.unmanagedvCpus;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.tags = builder.tags;
        this.type = builder.type;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
        this.updatePolicy = builder.updatePolicy;
        this.eksConfiguration = builder.eksConfiguration;
        this.containerOrchestrationType = builder.containerOrchestrationType;
        this.uuid = builder.uuid;
    }

    public final String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public final String computeEnvironmentArn() {
        return this.computeEnvironmentArn;
    }

    public final Integer unmanagedvCpus() {
        return this.unmanagedvCpus;
    }

    public final String ecsClusterArn() {
        return this.ecsClusterArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final CEType type() {
        return CEType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CEState state() {
        return CEState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final CEStatus status() {
        return CEStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final ComputeResource computeResources() {
        return this.computeResources;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final UpdatePolicy updatePolicy() {
        return this.updatePolicy;
    }

    public final EksConfiguration eksConfiguration() {
        return this.eksConfiguration;
    }

    public final OrchestrationType containerOrchestrationType() {
        return OrchestrationType.fromValue(this.containerOrchestrationType);
    }

    public final String containerOrchestrationTypeAsString() {
        return this.containerOrchestrationType;
    }

    public final String uuid() {
        return this.uuid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmanagedvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOrchestrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentDetail)) {
            return false;
        }
        ComputeEnvironmentDetail other = (ComputeEnvironmentDetail)obj;
        return Objects.equals(this.computeEnvironmentName(), other.computeEnvironmentName()) && Objects.equals(this.computeEnvironmentArn(), other.computeEnvironmentArn()) && Objects.equals(this.unmanagedvCpus(), other.unmanagedvCpus()) && Objects.equals(this.ecsClusterArn(), other.ecsClusterArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.computeResources(), other.computeResources()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.updatePolicy(), other.updatePolicy()) && Objects.equals(this.eksConfiguration(), other.eksConfiguration()) && Objects.equals(this.containerOrchestrationTypeAsString(), other.containerOrchestrationTypeAsString()) && Objects.equals(this.uuid(), other.uuid());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeEnvironmentDetail").add("ComputeEnvironmentName", (Object)this.computeEnvironmentName()).add("ComputeEnvironmentArn", (Object)this.computeEnvironmentArn()).add("UnmanagedvCpus", (Object)this.unmanagedvCpus()).add("EcsClusterArn", (Object)this.ecsClusterArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("ComputeResources", (Object)this.computeResources()).add("ServiceRole", (Object)this.serviceRole()).add("UpdatePolicy", (Object)this.updatePolicy()).add("EksConfiguration", (Object)this.eksConfiguration()).add("ContainerOrchestrationType", (Object)this.containerOrchestrationTypeAsString()).add("Uuid", (Object)this.uuid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentName()));
            }
            case "computeEnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentArn()));
            }
            case "unmanagedvCpus": {
                return Optional.ofNullable(clazz.cast(this.unmanagedvCpus()));
            }
            case "ecsClusterArn": {
                return Optional.ofNullable(clazz.cast(this.ecsClusterArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "computeResources": {
                return Optional.ofNullable(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "updatePolicy": {
                return Optional.ofNullable(clazz.cast(this.updatePolicy()));
            }
            case "eksConfiguration": {
                return Optional.ofNullable(clazz.cast(this.eksConfiguration()));
            }
            case "containerOrchestrationType": {
                return Optional.ofNullable(clazz.cast(this.containerOrchestrationTypeAsString()));
            }
            case "uuid": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeEnvironmentDetail, T> g) {
        return obj -> g.apply((ComputeEnvironmentDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String computeEnvironmentArn;
        private Integer unmanagedvCpus;
        private String ecsClusterArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private String state;
        private String status;
        private String statusReason;
        private ComputeResource computeResources;
        private String serviceRole;
        private UpdatePolicy updatePolicy;
        private EksConfiguration eksConfiguration;
        private String containerOrchestrationType;
        private String uuid;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentDetail model) {
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.computeEnvironmentArn(model.computeEnvironmentArn);
            this.unmanagedvCpus(model.unmanagedvCpus);
            this.ecsClusterArn(model.ecsClusterArn);
            this.tags(model.tags);
            this.type(model.type);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
            this.updatePolicy(model.updatePolicy);
            this.eksConfiguration(model.eksConfiguration);
            this.containerOrchestrationType(model.containerOrchestrationType);
            this.uuid(model.uuid);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final Integer getUnmanagedvCpus() {
            return this.unmanagedvCpus;
        }

        public final void setUnmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
        }

        @Override
        public final Builder unmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        public final String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CEStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final ComputeResource.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final UpdatePolicy.Builder getUpdatePolicy() {
            return this.updatePolicy != null ? this.updatePolicy.toBuilder() : null;
        }

        public final void setUpdatePolicy(UpdatePolicy.BuilderImpl updatePolicy) {
            this.updatePolicy = updatePolicy != null ? updatePolicy.build() : null;
        }

        @Override
        public final Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        public final EksConfiguration.Builder getEksConfiguration() {
            return this.eksConfiguration != null ? this.eksConfiguration.toBuilder() : null;
        }

        public final void setEksConfiguration(EksConfiguration.BuilderImpl eksConfiguration) {
            this.eksConfiguration = eksConfiguration != null ? eksConfiguration.build() : null;
        }

        @Override
        public final Builder eksConfiguration(EksConfiguration eksConfiguration) {
            this.eksConfiguration = eksConfiguration;
            return this;
        }

        public final String getContainerOrchestrationType() {
            return this.containerOrchestrationType;
        }

        public final void setContainerOrchestrationType(String containerOrchestrationType) {
            this.containerOrchestrationType = containerOrchestrationType;
        }

        @Override
        public final Builder containerOrchestrationType(String containerOrchestrationType) {
            this.containerOrchestrationType = containerOrchestrationType;
            return this;
        }

        @Override
        public final Builder containerOrchestrationType(OrchestrationType containerOrchestrationType) {
            this.containerOrchestrationType(containerOrchestrationType == null ? null : containerOrchestrationType.toString());
            return this;
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public ComputeEnvironmentDetail build() {
            return new ComputeEnvironmentDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeEnvironmentDetail> {
        public Builder computeEnvironmentName(String var1);

        public Builder computeEnvironmentArn(String var1);

        public Builder unmanagedvCpus(Integer var1);

        public Builder ecsClusterArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(CEType var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder status(String var1);

        public Builder status(CEStatus var1);

        public Builder statusReason(String var1);

        public Builder computeResources(ComputeResource var1);

        default public Builder computeResources(Consumer<ComputeResource.Builder> computeResources) {
            return this.computeResources((ComputeResource)((ComputeResource.Builder)ComputeResource.builder().applyMutation(computeResources)).build());
        }

        public Builder serviceRole(String var1);

        public Builder updatePolicy(UpdatePolicy var1);

        default public Builder updatePolicy(Consumer<UpdatePolicy.Builder> updatePolicy) {
            return this.updatePolicy((UpdatePolicy)((UpdatePolicy.Builder)UpdatePolicy.builder().applyMutation(updatePolicy)).build());
        }

        public Builder eksConfiguration(EksConfiguration var1);

        default public Builder eksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
            return this.eksConfiguration((EksConfiguration)((EksConfiguration.Builder)EksConfiguration.builder().applyMutation(eksConfiguration)).build());
        }

        public Builder containerOrchestrationType(String var1);

        public Builder containerOrchestrationType(OrchestrationType var1);

        public Builder uuid(String var1);
    }
}

