/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlatformCapability {
    EC2("EC2"),
    FARGATE("FARGATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlatformCapability> VALUE_MAP;
    private final String value;

    private PlatformCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlatformCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlatformCapability> knownValues() {
        EnumSet<PlatformCapability> knownValues = EnumSet.allOf(PlatformCapability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlatformCapability.class, PlatformCapability::toString);
    }
}

