/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.NodePropertyOverride;
import software.amazon.awssdk.services.batch.model.NodePropertyOverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeOverrides> {
    private static final SdkField<Integer> NUM_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numNodes").getter(NodeOverrides.getter(NodeOverrides::numNodes)).setter(NodeOverrides.setter(Builder::numNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodes").build()}).build();
    private static final SdkField<List<NodePropertyOverride>> NODE_PROPERTY_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodePropertyOverrides").getter(NodeOverrides.getter(NodeOverrides::nodePropertyOverrides)).setter(NodeOverrides.setter(Builder::nodePropertyOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodePropertyOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodePropertyOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_NODES_FIELD, NODE_PROPERTY_OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer numNodes;
    private final List<NodePropertyOverride> nodePropertyOverrides;

    private NodeOverrides(BuilderImpl builder) {
        this.numNodes = builder.numNodes;
        this.nodePropertyOverrides = builder.nodePropertyOverrides;
    }

    public Integer numNodes() {
        return this.numNodes;
    }

    public boolean hasNodePropertyOverrides() {
        return this.nodePropertyOverrides != null && !(this.nodePropertyOverrides instanceof SdkAutoConstructList);
    }

    public List<NodePropertyOverride> nodePropertyOverrides() {
        return this.nodePropertyOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodePropertyOverrides() ? this.nodePropertyOverrides() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOverrides)) {
            return false;
        }
        NodeOverrides other = (NodeOverrides)obj;
        return Objects.equals(this.numNodes(), other.numNodes()) && this.hasNodePropertyOverrides() == other.hasNodePropertyOverrides() && Objects.equals(this.nodePropertyOverrides(), other.nodePropertyOverrides());
    }

    public String toString() {
        return ToString.builder((String)"NodeOverrides").add("NumNodes", (Object)this.numNodes()).add("NodePropertyOverrides", this.hasNodePropertyOverrides() ? this.nodePropertyOverrides() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numNodes": {
                return Optional.ofNullable(clazz.cast(this.numNodes()));
            }
            case "nodePropertyOverrides": {
                return Optional.ofNullable(clazz.cast(this.nodePropertyOverrides()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeOverrides, T> g) {
        return obj -> g.apply((NodeOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numNodes;
        private List<NodePropertyOverride> nodePropertyOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOverrides model) {
            this.numNodes(model.numNodes);
            this.nodePropertyOverrides(model.nodePropertyOverrides);
        }

        public final Integer getNumNodes() {
            return this.numNodes;
        }

        @Override
        public final Builder numNodes(Integer numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        public final void setNumNodes(Integer numNodes) {
            this.numNodes = numNodes;
        }

        public final Collection<NodePropertyOverride.Builder> getNodePropertyOverrides() {
            if (this.nodePropertyOverrides instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodePropertyOverrides != null ? (Collection)this.nodePropertyOverrides.stream().map(NodePropertyOverride::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodePropertyOverrides(Collection<NodePropertyOverride> nodePropertyOverrides) {
            this.nodePropertyOverrides = NodePropertyOverridesCopier.copy(nodePropertyOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodePropertyOverrides(NodePropertyOverride ... nodePropertyOverrides) {
            this.nodePropertyOverrides(Arrays.asList(nodePropertyOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodePropertyOverrides(Consumer<NodePropertyOverride.Builder> ... nodePropertyOverrides) {
            this.nodePropertyOverrides(Stream.of(nodePropertyOverrides).map(c -> (NodePropertyOverride)((NodePropertyOverride.Builder)NodePropertyOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodePropertyOverrides(Collection<NodePropertyOverride.BuilderImpl> nodePropertyOverrides) {
            this.nodePropertyOverrides = NodePropertyOverridesCopier.copyFromBuilder(nodePropertyOverrides);
        }

        public NodeOverrides build() {
            return new NodeOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeOverrides> {
        public Builder numNodes(Integer var1);

        public Builder nodePropertyOverrides(Collection<NodePropertyOverride> var1);

        public Builder nodePropertyOverrides(NodePropertyOverride ... var1);

        public Builder nodePropertyOverrides(Consumer<NodePropertyOverride.Builder> ... var1);
    }
}

