/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ArrayJobStatusSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArrayPropertiesDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArrayPropertiesDetail> {
    private static final SdkField<Map<String, Integer>> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusSummary").getter(ArrayPropertiesDetail.getter(ArrayPropertiesDetail::statusSummary)).setter(ArrayPropertiesDetail.setter(Builder::statusSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("size").getter(ArrayPropertiesDetail.getter(ArrayPropertiesDetail::size)).setter(ArrayPropertiesDetail.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("index").getter(ArrayPropertiesDetail.getter(ArrayPropertiesDetail::index)).setter(ArrayPropertiesDetail.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_SUMMARY_FIELD, SIZE_FIELD, INDEX_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> statusSummary;
    private final Integer size;
    private final Integer index;

    private ArrayPropertiesDetail(BuilderImpl builder) {
        this.statusSummary = builder.statusSummary;
        this.size = builder.size;
        this.index = builder.index;
    }

    public boolean hasStatusSummary() {
        return this.statusSummary != null && !(this.statusSummary instanceof SdkAutoConstructMap);
    }

    public Map<String, Integer> statusSummary() {
        return this.statusSummary;
    }

    public Integer size() {
        return this.size;
    }

    public Integer index() {
        return this.index;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayPropertiesDetail)) {
            return false;
        }
        ArrayPropertiesDetail other = (ArrayPropertiesDetail)obj;
        return Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.index(), other.index());
    }

    public String toString() {
        return ToString.builder((String)"ArrayPropertiesDetail").add("StatusSummary", this.statusSummary()).add("Size", (Object)this.size()).add("Index", (Object)this.index()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArrayPropertiesDetail, T> g) {
        return obj -> g.apply((ArrayPropertiesDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> statusSummary = DefaultSdkAutoConstructMap.getInstance();
        private Integer size;
        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayPropertiesDetail model) {
            this.statusSummary(model.statusSummary);
            this.size(model.size);
            this.index(model.index);
        }

        public final Map<String, Integer> getStatusSummary() {
            return this.statusSummary;
        }

        @Override
        public final Builder statusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
            return this;
        }

        public final void setStatusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public ArrayPropertiesDetail build() {
            return new ArrayPropertiesDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArrayPropertiesDetail> {
        public Builder statusSummary(Map<String, Integer> var1);

        public Builder size(Integer var1);

        public Builder index(Integer var1);
    }
}

