/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the elastic network interface for a multi-node parallel job node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()).build();

    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::ipv6Address)).setter(setter(Builder::ipv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Address").build()).build();

    private static final SdkField<String> PRIVATE_IPV4_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateIpv4Address)).setter(setter(Builder::privateIpv4Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpv4Address").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            IPV6_ADDRESS_FIELD, PRIVATE_IPV4_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachmentId;

    private final String ipv6Address;

    private final String privateIpv4Address;

    private NetworkInterface(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.ipv6Address = builder.ipv6Address;
        this.privateIpv4Address = builder.privateIpv4Address;
    }

    /**
     * <p>
     * The attachment ID for the network interface.
     * </p>
     * 
     * @return The attachment ID for the network interface.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The private IPv6 address for the network interface.
     * </p>
     * 
     * @return The private IPv6 address for the network interface.
     */
    public String ipv6Address() {
        return ipv6Address;
    }

    /**
     * <p>
     * The private IPv4 address for the network interface.
     * </p>
     * 
     * @return The private IPv4 address for the network interface.
     */
    public String privateIpv4Address() {
        return privateIpv4Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpv4Address());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(ipv6Address(), other.ipv6Address())
                && Objects.equals(privateIpv4Address(), other.privateIpv4Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInterface").add("AttachmentId", attachmentId()).add("Ipv6Address", ipv6Address())
                .add("PrivateIpv4Address", privateIpv4Address()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "ipv6Address":
            return Optional.ofNullable(clazz.cast(ipv6Address()));
        case "privateIpv4Address":
            return Optional.ofNullable(clazz.cast(privateIpv4Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The attachment ID for the network interface.
         * </p>
         * 
         * @param attachmentId
         *        The attachment ID for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The private IPv6 address for the network interface.
         * </p>
         * 
         * @param ipv6Address
         *        The private IPv6 address for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);

        /**
         * <p>
         * The private IPv4 address for the network interface.
         * </p>
         * 
         * @param privateIpv4Address
         *        The private IPv4 address for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpv4Address(String privateIpv4Address);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String ipv6Address;

        private String privateIpv4Address;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            attachmentId(model.attachmentId);
            ipv6Address(model.ipv6Address);
            privateIpv4Address(model.privateIpv4Address);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public final String getPrivateIpv4Address() {
            return privateIpv4Address;
        }

        @Override
        public final Builder privateIpv4Address(String privateIpv4Address) {
            this.privateIpv4Address = privateIpv4Address;
            return this;
        }

        public final void setPrivateIpv4Address(String privateIpv4Address) {
            this.privateIpv4Address = privateIpv4Address;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
