/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.JobSummary;
import software.amazon.awssdk.services.batch.model.JobSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListJobsResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private final List<JobSummary> jobSummaryList;
    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaryList = builder.jobSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<JobSummary> jobSummaryList() {
        return this.jobSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        return Objects.equals(this.jobSummaryList(), other.jobSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsResponse").add("JobSummaryList", this.jobSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobSummaryList": {
                return Optional.of(clazz.cast(this.jobSummaryList()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<JobSummary> jobSummaryList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            this.jobSummaryList(model.jobSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobSummary.Builder> getJobSummaryList() {
            return this.jobSummaryList != null ? (Collection)this.jobSummaryList.stream().map(JobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobSummaryList(Collection<JobSummary> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copy(jobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(JobSummary ... jobSummaryList) {
            this.jobSummaryList(Arrays.asList(jobSummaryList));
            return this;
        }

        public final void setJobSummaryList(Collection<JobSummary.BuilderImpl> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copyFromBuilder(jobSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    CopyableBuilder<Builder, ListJobsResponse> {
        public Builder jobSummaryList(Collection<JobSummary> var1);

        public Builder jobSummaryList(JobSummary ... var1);

        public Builder nextToken(String var1);
    }
}

