/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeResourceUpdate;

@SdkInternalApi
public class ComputeResourceUpdateMarshaller {
    private static final MarshallingInfo<Integer> MINVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minvCpus").build();
    private static final MarshallingInfo<Integer> MAXVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxvCpus").build();
    private static final MarshallingInfo<Integer> DESIREDVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredvCpus").build();
    private static final ComputeResourceUpdateMarshaller INSTANCE = new ComputeResourceUpdateMarshaller();

    public static ComputeResourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComputeResourceUpdate computeResourceUpdate, ProtocolMarshaller protocolMarshaller) {
        if (computeResourceUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)computeResourceUpdate.minvCpus(), MINVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResourceUpdate.maxvCpus(), MAXVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResourceUpdate.desiredvCpus(), DESIREDVCPUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

