/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;
import software.amazon.awssdk.services.batch.model.JobQueueDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobQueuesResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeJobQueuesResponse> {
    private final List<JobQueueDetail> jobQueues;
    private final String nextToken;

    private DescribeJobQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.jobQueues = builder.jobQueues;
        this.nextToken = builder.nextToken;
    }

    public List<JobQueueDetail> jobQueues() {
        return this.jobQueues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueues());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesResponse)) {
            return false;
        }
        DescribeJobQueuesResponse other = (DescribeJobQueuesResponse)((Object)obj);
        return Objects.equals(this.jobQueues(), other.jobQueues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobQueues() != null) {
            sb.append("JobQueues: ").append(this.jobQueues()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueues": {
                return Optional.of(clazz.cast(this.jobQueues()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<JobQueueDetail> jobQueues;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesResponse model) {
            this.jobQueues(model.jobQueues);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobQueueDetail.Builder> getJobQueues() {
            return this.jobQueues != null ? (Collection)this.jobQueues.stream().map(JobQueueDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(JobQueueDetail ... jobQueues) {
            this.jobQueues(Arrays.asList(jobQueues));
            return this;
        }

        public final void setJobQueues(Collection<JobQueueDetail.BuilderImpl> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copyFromBuilder(jobQueues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobQueuesResponse build() {
            return new DescribeJobQueuesResponse(this);
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    CopyableBuilder<Builder, DescribeJobQueuesResponse> {
        public Builder jobQueues(Collection<JobQueueDetail> var1);

        public Builder jobQueues(JobQueueDetail ... var1);

        public Builder nextToken(String var1);
    }
}

