/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.JobDefinition;

@SdkInternalApi
public class JobDefinitionMarshaller {
    private static final MarshallingInfo<String> JOBDEFINITIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinitionName").build();
    private static final MarshallingInfo<String> JOBDEFINITIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinitionArn").build();
    private static final MarshallingInfo<Integer> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<StructuredPojo> RETRYSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryStrategy").build();
    private static final MarshallingInfo<StructuredPojo> CONTAINERPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerProperties").build();
    private static final JobDefinitionMarshaller INSTANCE = new JobDefinitionMarshaller();

    public static JobDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobDefinition jobDefinition, ProtocolMarshaller protocolMarshaller) {
        if (jobDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobDefinition.jobDefinitionName(), JOBDEFINITIONNAME_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.jobDefinitionArn(), JOBDEFINITIONARN_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.revision(), REVISION_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.type(), TYPE_BINDING);
            protocolMarshaller.marshall(jobDefinition.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.retryStrategy(), RETRYSTRATEGY_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.containerProperties(), CONTAINERPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

