/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateComputeEnvironmentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UpdateComputeEnvironmentResponse> {
    private final String computeEnvironmentName;
    private final String computeEnvironmentArn;

    private UpdateComputeEnvironmentResponse(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
    }

    public String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public String computeEnvironmentArn() {
        return this.computeEnvironmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentResponse)) {
            return false;
        }
        UpdateComputeEnvironmentResponse other = (UpdateComputeEnvironmentResponse)((Object)obj);
        return Objects.equals(this.computeEnvironmentName(), other.computeEnvironmentName()) && Objects.equals(this.computeEnvironmentArn(), other.computeEnvironmentArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.computeEnvironmentName() != null) {
            sb.append("ComputeEnvironmentName: ").append(this.computeEnvironmentName()).append(",");
        }
        if (this.computeEnvironmentArn() != null) {
            sb.append("ComputeEnvironmentArn: ").append(this.computeEnvironmentArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.of(clazz.cast(this.computeEnvironmentName()));
            }
            case "computeEnvironmentArn": {
                return Optional.of(clazz.cast(this.computeEnvironmentArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String computeEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentResponse model) {
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.computeEnvironmentArn(model.computeEnvironmentArn);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        public UpdateComputeEnvironmentResponse build() {
            return new UpdateComputeEnvironmentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateComputeEnvironmentResponse> {
        public Builder computeEnvironmentName(String var1);

        public Builder computeEnvironmentArn(String var1);
    }
}

