/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.ComputeResourceUpdate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateComputeEnvironmentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
    private final String computeEnvironment;
    private final String state;
    private final ComputeResourceUpdate computeResources;
    private final String serviceRole;

    private UpdateComputeEnvironmentRequest(BuilderImpl builder) {
        this.computeEnvironment = builder.computeEnvironment;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    public String computeEnvironment() {
        return this.computeEnvironment;
    }

    public CEState state() {
        return CEState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public ComputeResourceUpdate computeResources() {
        return this.computeResources;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentRequest)) {
            return false;
        }
        UpdateComputeEnvironmentRequest other = (UpdateComputeEnvironmentRequest)((Object)obj);
        return Objects.equals(this.computeEnvironment(), other.computeEnvironment()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.computeResources(), other.computeResources()) && Objects.equals(this.serviceRole(), other.serviceRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.computeEnvironment() != null) {
            sb.append("ComputeEnvironment: ").append(this.computeEnvironment()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.computeResources() != null) {
            sb.append("ComputeResources: ").append(this.computeResources()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironment": {
                return Optional.of(clazz.cast(this.computeEnvironment()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "computeResources": {
                return Optional.of(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String computeEnvironment;
        private String state;
        private ComputeResourceUpdate computeResources;
        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentRequest model) {
            this.computeEnvironment(model.computeEnvironment);
            this.state(model.state);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResourceUpdate.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResourceUpdate computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResourceUpdate.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public UpdateComputeEnvironmentRequest build() {
            return new UpdateComputeEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
        public Builder computeEnvironment(String var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder computeResources(ComputeResourceUpdate var1);

        default public Builder computeResources(Consumer<ComputeResourceUpdate.Builder> computeResources) {
            return this.computeResources((ComputeResourceUpdate)((ComputeResourceUpdate.Builder)ComputeResourceUpdate.builder().apply(computeResources)).build());
        }

        public Builder serviceRole(String var1);
    }
}

