/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobDefinitionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeJobDefinitionsRequest> {
    private final List<String> jobDefinitions;
    private final Integer maxResults;
    private final String jobDefinitionName;
    private final String status;
    private final String nextToken;

    private DescribeJobDefinitionsRequest(BuilderImpl builder) {
        this.jobDefinitions = builder.jobDefinitions;
        this.maxResults = builder.maxResults;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    public List<String> jobDefinitions() {
        return this.jobDefinitions;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public String status() {
        return this.status;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsRequest)) {
            return false;
        }
        DescribeJobDefinitionsRequest other = (DescribeJobDefinitionsRequest)((Object)obj);
        return Objects.equals(this.jobDefinitions(), other.jobDefinitions()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobDefinitions() != null) {
            sb.append("JobDefinitions: ").append(this.jobDefinitions()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(this.jobDefinitionName()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitions": {
                return Optional.of(clazz.cast(this.jobDefinitions()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "jobDefinitionName": {
                return Optional.of(clazz.cast(this.jobDefinitionName()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> jobDefinitions;
        private Integer maxResults;
        private String jobDefinitionName;
        private String status;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsRequest model) {
            this.jobDefinitions(model.jobDefinitions);
            this.maxResults(model.maxResults);
            this.jobDefinitionName(model.jobDefinitionName);
            this.status(model.status);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getJobDefinitions() {
            return this.jobDefinitions;
        }

        @Override
        public final Builder jobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(String ... jobDefinitions) {
            this.jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        public final void setJobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeJobDefinitionsRequest build() {
            return new DescribeJobDefinitionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobDefinitionsRequest> {
        public Builder jobDefinitions(Collection<String> var1);

        public Builder jobDefinitions(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder jobDefinitionName(String var1);

        public Builder status(String var1);

        public Builder nextToken(String var1);
    }
}

