/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.MountPoint;

@SdkInternalApi
public class MountPointMarshaller {
    private static final MarshallingInfo<String> CONTAINERPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPath").build();
    private static final MarshallingInfo<Boolean> READONLY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readOnly").build();
    private static final MarshallingInfo<String> SOURCEVOLUME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVolume").build();
    private static final MountPointMarshaller INSTANCE = new MountPointMarshaller();

    public static MountPointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MountPoint mountPoint, ProtocolMarshaller protocolMarshaller) {
        if (mountPoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mountPoint.containerPath(), CONTAINERPATH_BINDING);
            protocolMarshaller.marshall((Object)mountPoint.readOnly(), READONLY_BINDING);
            protocolMarshaller.marshall((Object)mountPoint.sourceVolume(), SOURCEVOLUME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

